#
##
##  This file is part of pyFormex 2.4  (Thu Feb 25 13:39:20 CET 2021)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2020 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""Spirals

This example shows how to create a spiral curve and how to spread points
evenly along a curve.

See also the Sweep example for a more sophisticated application of spirals.
"""


_status = 'checked'
_level = 'normal'
_topics = ['geometry', 'curve']
_techniques = ['transform', 'spiral']

from pyformex.gui.draw import *
from pyformex.plugins import curve

def spiral(X, dir=[0, 1, 2], rfunc=lambda x: 1, zfunc=lambda x: 0):
    """Perform a spiral transformation on a coordinate array"""
    theta = X[..., dir[0]]
    #print(theta)
    r = rfunc(theta) + X[..., dir[1]]
    x = r * cos(theta)
    y = r * sin(theta)
    z = zfunc(theta) + X[..., dir[2]]
    X = hstack([x, y, z]).reshape(X.shape)
    return Coords(X)

def createLine(nseg, turns):
    """Create a line along x-as with nseg segments and length nturns*2*pi"""
    F = Formex(origin())     # a point at the origin
    F = F.replicate(nseg+1)  # replicate nseg+1 times
    s = turns*2*pi/nseg      # scale to get length = nturns * 2 * pi
    F = F.scale(s)
    return F

def createSpiral(nseg=100, turns=1., phi=30., alpha=70., c=0.):
    F = createLine(nseg, turns)
    a = tand(phi)
    b = tand(phi) / tand(alpha)
    zf = lambda x: c * exp(b*x)
    rf = lambda x: a * exp(b*x)
    S = spiral(F.coords, [0, 1, 2], rf, zf)
    PL = curve.PolyLine(S[:, 0, :])
    return PL

def run():
    linewidth(2)
    clear()
    flat()
    view('front')
    F = createLine(100, 1.)
    PL = createSpiral(100, 1.)
    draw(origin())
    draw(F, color=blue)
    drawNumbers(F, color=blue)
    draw(PL, color=red)
    draw(PL.coords, color=red)
    drawNumbers(PL.coords, color=red)
    zoomAll()
    return


    if ack("Spread point evenly?"):
        at = PL.atLength(PL.nparts)
        X = PL.pointsAt(at)
        PL2 = curve.PolyLine(X)
        clear()
        draw(PL2, color=blue)
        draw(PL2.coords, color=blue)

if __name__ == '__draw__':
    run()
# End
