# flake8: noqa
##
##  This file is part of pyFormex 2.5  (Wed Mar 24 20:37:37 CET 2021)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2021 (C) Benedict Verhegghe (bverheg@gmail.com)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""Default imports in the scripting language.

This module defines which definitions are always imported when
you run a script, and are thus considered integral part
of the pyFormex scripting language.

For an app, you get this definitions if you add::

  from pyformex.script import *

or::

  from pyformex.gui.draw import *

Warning
-------
This is subject to future changes.
"""

import numpy as np

import pyformex as pf
from pyformex import utils
from pyformex import arraytools as at
from pyformex import coords
from pyformex import formex
from pyformex import mesh
from pyformex import simple

from pyformex import Path
from pyformex.colors import *
from pyformex.coords import *
from pyformex.formex import *
from pyformex.mesh import Mesh
from pyformex.olist import List
from pyformex.varray import Varray
from pyformex.elements import Elems
from pyformex.trisurface import TriSurface
from pyformex.coordsys import CoordSys
from pyformex.plugins.curve import PolyLine, BezierSpline
from pyformex.geomfile import *
from pyformex.project import Project
from pyformex.saveload import savePZF, loadPZF

from numpy import pi, sin, cos, tan, arcsin, arccos, arctan, arctan2, sqrt, abs
from numpy.linalg import norm

from pyformex.arraytools import *
from numpy import *
