#

"""Try to read all .pyf files in some directory (and its subdirs)

The script will ask to select a directory name, lookup all '*.pyf'
file below that path, and then try to read each of this project files.

This script is intended to test whether your files can still be opened
and read in newer pyFormex versions.

In case of failures, set the PROJECT debug flag to get more info.

"""


dirname = pf.pyformexdir / 'pyformex' / 'data'
dirname = askDirname(dirname)
files = dirname.listTree(includefile='.*\.pyf')


def test_open_project(f):
    try:
        P = Project(f)
        print(P.keys())
        print("OK")
        return P
    except Exception as e:
        print(e)
        print("FAIL")

for f in sorted(files):
    print("="*72)
    print("Filename: %s" % f)
    P = test_open_project(f)


# End
