#
##
##  SPDX-FileCopyrightText: © 2007-2023 Benedict Verhegghe <bverheg@gmail.com>
##  SPDX-License-Identifier: GPL-3.0-or-later
##
##  This file is part of pyFormex 3.4  (Thu Nov 16 18:07:39 CET 2023)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: https://pyformex.org
##  Project page: https://savannah.nongnu.org/projects/pyformex/
##  Development: https://gitlab.com/bverheg/pyformex
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""ColorPick

This example shows a custom colormap and allows the user to pick a color
and retrieve its name and value. Currently it only
"""

_level = 'normal'
_topics = ['color']
_techniques = ['color', 'colormap', 'pick']

from pyformex.gui.draw import *
from pyformex import colors
import math

colordict = colors.X11_colors
colormap = np.array(list(colordict.values())) / 255.
colornames = list(colordict)
maxlen = max(len(color) for color in colordict)
print(maxlen)
square = "\u2B1B\u2B1B"

def print_color(i):
    color = colornames[i]
    rgb = colordict[color]
    gl = colors.GLcolor(rgb)
    rgbstr = f"({rgb[0]:3}, {rgb[1]:3}, {rgb[2]:3})"
    glstr = f"({gl[0]:.6f}, {gl[1]:.6f}, {gl[2]:.6f})"
    web = colors.WEBcolor(rgb)
    printc(square, end='', color=gl)
    print(f" rgb={rgbstr}, gl={glstr}, {web=}, ", end='')
    print(f"name={color!r}")

def report_color(self):
    try:
        i = self.picked[0][0]
        print_color(i)
    except Exception as e:
        print(e)
        pass

def run():
    clear()
    flatwire()
    ncolors = len(X11_colors)
    ny = math.ceil(math.sqrt(ncolors / pf.canvas.aspect))
    nx = math.ceil(ncolors / ny)
    M = Mesh(eltype='quad4').scale(pf.canvas.aspect, 0).subdivide(nx, ny)
    M.setProp('range')
    iblack = colornames.index('black')
    M.prop[M.prop >= ncolors] = iblack
    draw(M, colormap=colormap)
    pick('element', func=report_color, prompt='Pick any color to show its name and value (ESC or right mouse to stop)')


if __name__ == '__draw__':
    run()

# End
