#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2006 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2006 MiKael NAVARRO

Constants definition.
"""

# Include directives
from npi_utils import func_name  # decorator: set func_name
from math import pi, e 


#
# PI (3.14159265359).
#
@func_name("pi")
def npi_pi(stack):
  """Return PI

  >>> from stack import Stack
  >>> npi_pi(Stack([])) # doctest:+ELLIPSIS
  [3.14...]
  """
  
  stack.push(pi)

  return stack


#
# e (2.71828182846).
#
@func_name("e")
def npi_e(stack):
  """Return e

  >>> from stack import Stack
  >>> npi_e(Stack([])) # doctest:+ELLIPSIS
  [2.71...]
  """

  stack.push(e)
  
  return stack


#
# Self-test.
#
def _test():
  import doctest
  print("Testing 'Constants' commands...", end="")
  (failure_count, test_count) = doctest.testmod()
  if not failure_count: print("Okey")
  else: print("Ko!")


#
# External entry point.
#
if __name__ == "__main__":
  _test()
