#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2011 MiKael NAVARRO

Hyperbolic trigonometric commands.
"""

# Include directives
from npi_errors import TooFewArguments  # NPI errors
from npi_utils import func_name  # decorator: set func_name
from math import sinh, cosh, tanh


#
# Sin.
#
@func_name("sinh")
def npi_sinh(stack):
  """Sineh X (radian)

  >>> from stack import Stack
  >>> npi_sinh(Stack([3.14]))  # doctest:+ELLIPSIS
  [11.5...]
  >>> npi_sinh(Stack([]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: sinh Error: Too Few Arguments
  """
  
  if len(stack) >= 1:
    stack.push(sinh(stack.pop()))
  else:
    raise TooFewArguments(npi_sinh)

  return stack


#
# Cos.
#
@func_name("cosh")
def npi_cosh(stack):
  """Cosineh X (radian)

  >>> from stack import Stack
  >>> npi_cosh(Stack([3.14]))  # doctest:+ELLIPSIS
  [11.5...]
  >>> npi_cosh(Stack([]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: cosh Error: Too Few Arguments
  """
  
  if len(stack) >= 1:
    stack.push(cosh(stack.pop()))
  else:
    raise TooFewArguments(npi_cosh)

  return stack


#
# Tan.
#
@func_name("tanh")
def npi_tanh(stack):
  """Tangenth X (radian)

  >>> from stack import Stack
  >>> npi_tanh(Stack([3.14]))  # doctest:+ELLIPSIS
  [0.99...]
  >>> npi_tanh(Stack([]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: tanh Error: Too Few Arguments
  """
  
  if len(stack) >= 1:
    stack.push(tanh(stack.pop()))
  else:
    raise TooFewArguments(npi_tanh)

  return stack


#
# Self-test.
#
def _test():
  import doctest
  print("Testing 'Hyperbolic Trigonometric' commands...", end="")
  (failure_count, test_count) = doctest.testmod()
  if not failure_count: print("Okey")
  else: print("Ko!")


#
# External entry point.
#
if __name__ == "__main__":
  _test()
