#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2011 MiKael NAVARRO

Random commands.
"""

# Include directives
from npi_errors import TooFewArguments, BadArgumentValue  # NPI errors
from npi_utils import func_name  # decorator: set func_name
from random import random, randint, randrange


#
# Random [0..1).
#
@func_name("rand")
def npi_rand(stack):
  """Random [0-1)

  >>> from stack import Stack
  >>> npi_rand(Stack([]))  # doctest:+ELLIPSIS
  [...]
  """
  
  stack.push(random())

  return stack


#
# Random [X..Y].
#
@func_name("randi")
def npi_randint(stack):
  """Random [X-Y]

  >>> from stack import Stack
  >>> npi_randint(Stack([20, 10]))  # doctest:+ELLIPSIS
  [...]
  >>> npi_randint(Stack([10, 20]))
  Traceback (most recent call last):
  ...
  npi_errors.BadArgumentValue: randi Error: Bad Argument Value
  >>> npi_randint(Stack([]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: randi Error: Too Few Arguments
  """

  if len(stack) >= 2:
    a, b = stack.pop(), stack.pop()
    if 0 <= a <= b:
      stack.push(randint(a, b))
    else:
      raise BadArgumentValue(npi_randint)
  else:
    raise TooFewArguments(npi_randint)

  return stack


#
# Random [X..Y].
#
@func_name("randr")
def npi_randrange(stack):
  """Random [X-Y]

  >>> from stack import Stack
  >>> npi_randrange(Stack([20, 10]))  # doctest:+ELLIPSIS
  [...]
  >>> npi_randrange(Stack([10, 20]))
  Traceback (most recent call last):
  ...
  npi_errors.BadArgumentValue: randr Error: Bad Argument Value
  >>> npi_randrange(Stack([]))
  Traceback (most recent call last):
  ...
  npi_errors.TooFewArguments: randr Error: Too Few Arguments
  """

  if len(stack) >= 2:
    a, b = stack.pop(), stack.pop()
    if 0 <= a <= b:
      stack.push(randrange(a, b, 1))
    else:
      raise BadArgumentValue(npi_randrange)
  else:
    raise TooFewArguments(npi_randrange)

  return stack


#
# Self-test.
#
def _test():
  import doctest
  print("Testing 'Random' commands...", end="")
  (failure_count, test_count) = doctest.testmod()
  if not failure_count: print("Okey")
  else: print("Ko!")


#
# External entry point.
#
if __name__ == "__main__":
  _test()
