#
# NPI - Calculatrice en Notation Polonaise Inverse. 
# Copyright (C) 2005-2011 MiKael NAVARRO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""NPI - Reverse Polish Notation Calculator. 
Copyright (C) 2005-2011 MiKael NAVARRO

NPI errors/exceptions..
"""

#
# Base class for exceptions in NPI modules.
#
class Error(Exception):
  """NPI base class for exceptions.
  
  func    function in which the error occurred
  errmsg  explanation of the error
  """
  
  def __init__(self, func, errmsg="Generic Error"):
      self.func = func.__name__
      self.errmsg = errmsg

  def __str__(self):
      return "{func} Error: {msg}".format(func=self.func, msg=self.errmsg)


#
# Too Few Arguments.
#
class TooFewArguments(Error):
  """Raised when few arguments are mising."""

  def __init__(self, func):
    Error.__init__(self, func, "Too Few Arguments")


#
# Bad Argument Type.
#
class BadArgumentType(Error):
  """Raised when a bad argument type is used."""

  def __init__(self, func):
    Error.__init__(self, func, "Bad Argument Type")


#
# Bad Argument Value.
#
class BadArgumentValue(Error):
  """Raised when a bad argument value is passed."""

  def __init__(self, func):
    Error.__init__(self, func, "Bad Argument Value")


#
# Infinite Result.
#
class InfiniteResult(Error):
  """Raised when a division by zero occured."""

  def __init__(self, func):
    Error.__init__(self, func, "Infinite Result")


#
# Not Yet Implemented
#
class NotYetImplemented(Error):
  """Raised when not yet implemented."""

  def __init__(self, func):
    Error.__init__(self, func, "Not Yet Implemented")
