#!/usr/bin/env python

# Copyright (c) 2005 Floris Bruynooghe

# All rights reserved.

# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, provided
# that the above copyright notice(s) and this permission notice appear
# in all copies of the Software and that both the above copyright
# notice(s) and this permission notice appear in supporting
# documentation.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR
# ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
# ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.

# Except as contained in this notice, the name of a copyright holder
# shall not be used in advertising or otherwise to promote the sale,
# use or other dealings in this Software without prior written
# authorization of the copyright holder.


"""Free drop in replacement for profile and pstats module.

This module distribution has two modules hprofile and hpstats that
behave exactly as the non-free profile and pstats modules.  This is
done by wrapping the hotshot profiler.

As a side effect there is also a native statistics module for hotshot,
hstats, and a modified version of the extension module _hotshot that
accepts differnt timer functions but is still backwards compatible.
"""


from distutils.core import setup, Extension


doclines = __doc__.splitlines()


setup(name="hprof",
      version="0.1.0",
      description=doclines[0],
      long_description="\n".join(doclines[2:]),
      author="Floris Bruynooghe",
      author_email="fb102@soton.ac.uk",
      url="http://savannah.nongnu.org/projects/pyprof/",
      license="MIT/X11",
      platforms=["any"],
      py_modules=["hprof/hstats", "hprof/hprofile", "hprof/hpstats",
                  "hprof/profile", "hprof/pstats"],
      ext_modules=[Extension("hprof/_hotshot", ["hprof/_hotshot.c"])],
      extra_path="hprof")
