/**
 PyCClass Tutorial
 Copyright (C) 2006 ParIT Worker Co-operative <http://www.parit.ca>

 Permission is granted to copy, distribute and/or modify this document
 under the terms of the GNU Free Documentation License, Version 1.2
 or any later version published by the Free Software Foundation;
 with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.

 A copy of the license is included in doc/COPYING
 */

%module gnucash_
%{
#include <guile/gh.h>

#include <gnucash/gnc-module.h>

#include <gnucash/qofbook.h>
#include <gnucash/Group.h>
#include <gnucash/Account.h>

%}

void scm_init_guile(void);
void g_type_init(void);

%include <gnucash/gnc-module.h>
%include <gnucash/qofbook.h>
%include <gnucash/Group.h>

// Can't do this because this header declares a function that does not 
// exist
// %include <gnucash/Account.h>

/** Constructor */
Account * xaccMallocAccount (QofBook *book);

/** Get the account's type */
GNCAccountType xaccAccountGetType (const Account *account);
/** Get the account's name */
const char * xaccAccountGetName (const Account *account);
/** Get the account's accounting code */
const char * xaccAccountGetCode (const Account *account);

/** Set the account's type */
void xaccAccountSetType (Account *account, GNCAccountType);
/** Set the account's name */
void xaccAccountSetName (Account *account, const char *name);
/** Set the account's accounting code */
void xaccAccountSetCode (Account *account, const char *code);
