"""An example package to demonstrate PyCClass in action
"""

"""Copyright (C) 2006 ParIT Worker Co-operative <http://parit.ca>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA  02110-1301  USA
 
Authors: Mark Jenkins <mark@parit.ca>
"""

import package_name_c_interface
from PyCClass import SelfMallocs

class Point(SelfMallocs):
    """ Example interactive ussage:
    
    >>> from package_name.package_name import Point
    >>> p = Point
    >>> p = Point()
    >>> p.move_up_right()
    >>> p.x
    1
    >>> p.y
    1

    """
    module = package_name_c_interface
    
    method_prefix = 'point_'
    _malloc = 'new'

    accessor_prefix = 'get_'
    mutator_prefix = 'set_'
    
    def get_x(self):
        return self.accessor('x')
    def set_x(self, x):
        self.mutator('x', x)
    x = property(get_x, set_x)

    def get_y(self):
        return self.accessor('y')
    def set_y(self, y):
        self.mutator('y', y)
    y = property(get_y, set_y)

    def move_up_right(self):
        self.method('move_up_right')
