#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/a/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_a = 4

n = qnum_a+1

question_a = [0]*n
answer_a = [0]*n
choice1_a = [0]*n
choice2_a = [0]*n
choice3_a = [0]*n
choice4_a = [0]*n
sound_a = [0]*n


question_a[0] = "Kepler's first law of planetary motion stated that orbits of planets are:"
choice1_a[0] = 'always circular'
choice2_a[0] = 'elliptical'
choice3_a[0] = 'random'
choice4_a[0] = 'tangential'
answer_a[0] = 2
sound_a[0] = checksound('a000.ogg')

question_a[1] = 'The mass of the sun is estimated to approximately be:'
choice1_a[1] = u'2 x 10\u00B3\u2070 kg'
choice2_a[1] = u'2 x 10\u2075 kg'
choice3_a[1] = u'2 x 10\u00B9\u2070 kg'
choice4_a[1] = u'20,000 kg'
answer_a[1] = 1
sound_a[1] = checksound('a001.ogg')

question_a[2] = "Jupiter's largest (size and mass) moon is known as?"
choice1_a[2] = 'Phobos'
choice2_a[2] = 'Ganymede'
choice3_a[2] = 'Europa'
choice4_a[2] = 'Callisto'
answer_a[2] = 2
sound_a[2] = checksound('a002.ogg')

question_a[3] = 'Polaris, the "North Star," belongs to which constellation?'
choice1_a[3] = 'Aries'
choice2_a[3] = 'Ursa Major'
choice3_a[3] = 'Orion'
choice4_a[3] = 'Ursa Minor'
answer_a[3] = 4
sound_a[3] = checksound('a003.ogg')

question_a[4] = 'How many days (yes, Earth days) does it take Mars to orbit the sun?'
choice1_a[4] = 'about 350 days'
choice2_a[4] = 'about 1000 days'
choice3_a[4] = 'about 100 days'
choice4_a[4] = 'about 700 days'
answer_a[4] = 4
sound_a[4] = checksound('a004.ogg')

