#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/csh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_csh = 4

n = qnum_csh+1
question_csh = [0]*n
answer_csh = [0]*n
choice1_csh = [0]*n
choice2_csh = [0]*n
choice3_csh = [0]*n
choice4_csh = [0]*n
sound_csh = [0]*n


question_csh[0] = 'The original announcement of the GNU Project, outlining the plans for the GNU project, was written by Richard Stallman in what year?' 
choice1_csh[0] = '1983'
choice2_csh[0] = '1993'
choice3_csh[0] = '1973'
choice4_csh[0] = '2003'
answer_csh[0] = 1
sound_csh[0] = checksound("csh000.ogg")

question_csh[1] = 'The Free Software Foundation was officially founded in what year?'
choice1_csh[1] = '1995'
choice2_csh[1] = '1980'
choice3_csh[1] = '1985'
choice4_csh[1] = '2001'
answer_csh[1] = 3
sound_csh[1] = checksound("csh001.ogg")



question_csh[2] = 'Development on the the Linux kernel was started in what year?'
choice1_csh[2] = '1991'
choice2_csh[2] = '1983'
choice3_csh[2] = '1984'
choice4_csh[2] = '1996'
answer_csh[2] = 1
sound_csh[2] = checksound("csh002.ogg")

question_csh[3] = 'The first complete version of the GNU GPL was released in what year?'
choice1_csh[3] = '1991'
choice2_csh[3] = '1989'
choice3_csh[3] = '1984'
choice4_csh[3] = '2000'
answer_csh[3] = 2
sound_csh[3] = checksound("csh003.ogg")

question_csh[4] = 'The 2001 Free Software Award went to who for their work on the Python programming language?'
choice1_csh[4] = 'Guido van Rossum'
choice2_csh[4] = 'Miguel de Icaza'
choice3_csh[4] = 'Alan Cox'
choice4_csh[4] = 'Brian Paul'
answer_csh[4] = 1
sound_csh[4] = checksound("csh004.ogg")
