#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/mh/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0


qnum_mh = 4
n = qnum_mh+1

question_mh = [0]*n
answer_mh = [0]*n
choice1_mh = [0]*n
choice2_mh = [0]*n
choice3_mh = [0]*n
choice4_mh = [0]*n
sound_mh = [0]*n


question_mh[0] = 'Who introduced the notation "e" for the natural base exponential?'
choice1_mh[0] = 'Leonhard Euler'
choice2_mh[0] = 'Gottfried Leibniz'
choice3_mh[0] = 'Pierre de Fermat'
choice4_mh[0] = 'Mikhail Vasilievich Ostrogradsky'
answer_mh[0] = 1
sound_mh[0] = checksound('mh000.ogg')

question_mh[1] = u'What chinese matematician was sucessful in estimating \u03C0 to 7 digits that remained the most accurate estimate for about a millenium?'
choice1_mh[1] = 'Zu Chongzhi'
choice2_mh[1] = 'Liu Hui'
choice3_mh[1] = 'Zu Geng'
choice4_mh[1] = 'Zhu Shijie'
answer_mh[1] = 1
sound_mh[1] = checksound('mh001.ogg')

question_mh[2] = "The most common numerals used around the world (the ones you're using now, such as 1, 2) originated from where?"
choice1_mh[2] = 'Arabian Peninsula'
choice2_mh[2] = 'India'
choice3_mh[2] = 'England'
choice4_mh[2] = 'Japan'
answer_mh[2] = 2
sound_mh[2] = checksound('mh002.ogg')

question_mh[3] = 'Who is credited to have developed calculus independantly from Issac Newton?'
choice1_mh[3] = 'Leonhard Euler'
choice2_mh[3] = 'Brook Taylor'
choice3_mh[3] = 'Carl Friedrich Gauss'
choice4_mh[3] = 'Gottfried Leibniz'
answer_mh[3] = 4
sound_mh[3] = checksound('mh003.ogg')

question_mh[4] = 'Who is credited with developing differential operators?'
choice1_mh[4] = u"Guillaume de l'H\u00F4pital"
choice2_mh[4] = 'Issac Newton'
choice3_mh[4] = 'Oliver Heaviside'
choice4_mh[4] = 'Paul Dirac'
answer_mh[4] = 3
sound_mh[4] = checksound('mh004.ogg')


