#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/p/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_p = 4

n = qnum_p + 1
question_p = [0]*n
answer_p = [0]*n
choice1_p = [0]*n
choice2_p = [0]*n
choice3_p = [0]*n
choice4_p = [0]*n
sound_p = [0]*n

question_p[0] = 'In classical mechanics, force is directly proportional to mass and?'
choice1_p[0] = 'energy'
choice2_p[0] = 'velocity'
choice3_p[0] = 'power'
choice4_p[0] = 'acceleration'
answer_p[0] = 4
sound_p[0] = checksound('p000.ogg')

question_p[1] = 'In thermodynamics, for an adiabatic process, which of the following is true?'
choice1_p[1] = 'pressure is constant'
choice2_p[1] = 'there is no change in heat'
choice3_p[1] = 'temperature is constant'
choice4_p[1] = 'volume doubles'
answer_p[1] = 2
sound_p[1] = checksound("p001.ogg")

question_p[2] = "Ohm's law shows that voltage is directly proportional to what?  Or other words, as voltage increases or decreases, what other quantity increases or decreases along with it?"
choice1_p[2] = 'only current'
choice2_p[2] = 'only resistance'
choice3_p[2] = 'current and resistance'
choice4_p[2] = 'nothing'
answer_p[2] = 3
sound_p[2] = checksound('p002.ogg')

question_p[3] = 'An elastic collision is a collision in which what is conserved?  Or in other words, what quantity is measured to be the same before and after the collision takes place?'
choice1_p[3] = 'kinetic energy'
choice2_p[3] = 'velocity'
choice3_p[3] = 'potential energy'
choice4_p[3] = 'momentum'
answer_p[3] = 1
sound_p[3] = checksound('p003.ogg')

question_p[4] = 'The universal gravitational constant, abbreviated G, is approximately equal to?'
choice1_p[4] = u'6.67 x 10\u00B9\u00B9 Nm\u00B2kg\u207B\u00B2'
choice2_p[4] = u'6.00 x 10\u00B9\u00B9 Nm\u00B2kg\u207B\u00B2'
choice3_p[4] = u'2.67 x 10\u00B9\u00B9 Nm\u00B2kg\u207B\u00B2'
choice4_p[4] = u'9.81 x Nm\u00B2kg\u207B\u00B2'
answer_p[4] = 1
sound_p[4] = checksound("p004.ogg")




