#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

sys.path.append('sounds')

#initialize pygame
pygame.init()

path = "data/questions/voice/ph/"
def checksound(sound):
	try:
		soundfile = path + sound
		open(soundfile)
		return pygame.mixer.Sound(soundfile)
	except IOError:
		return 0

qnum_ph = 4

n = qnum_ph+1
question_ph = [0]*n
answer_ph = [0]*n
choice1_ph = [0]*n
choice2_ph = [0]*n
choice3_ph = [0]*n
choice4_ph = [0]*n
sound_ph = [0]*n


question_ph[0] = 'What famous scientist is quoted to have said: "All science is either physics or stamp collecting."'
choice1_ph[0] = 'Issac Newton'
choice2_ph[0] = 'Richard Feynman'
choice3_ph[0] = 'Ernest Rutherford'
choice4_ph[0] = 'Michael Faraday'
answer_ph[0] = 3
sound_ph[0] = checksound('ph000.ogg')

question_ph[1] = u'The danish scientist, Hans Christian \u00D8rsted, is often credited for discovering this relationship first, but it may have been discovered by Gian Domenico Romagnosi, an Italian philosopher 20 years or so earlier.'
choice1_ph[1] = 'force and acceleration'
choice2_ph[1] = 'electricity and magnetism'
choice3_ph[1] = 'volume and temperature'
choice4_ph[1] = 'energy and mass'
answer_ph[1] = 2
sound_ph[1] = checksound('ph001.ogg')

question_ph[2] = 'What famous scientist was put under house arrest by the Catholic church for his work supporting a heliocentric solar system in his book, "Dialogue Concerning the Two Chief World Systems"'
choice1_ph[2] = 'Johannes Kepler'
choice2_ph[2] = 'Issac Newton'
choice3_ph[2] = 'Nicolaus Copernicus'
choice4_ph[2] = 'Galileo Galilei'
answer_ph[2] = 4
sound_ph[2] = checksound('ph002.ogg')

question_ph[3] = 'What famous physicist first developed the theories of special and general relativity?'
choice1_ph[3] = 'Albert Einstein'
choice2_ph[3] = 'Daniel Bernoulli'
choice3_ph[3] = 'Niels Bohr'
choice4_ph[3] = u'Erwin Schr\u00F6dinger'
answer_ph[3] = 1
sound_ph[3] = checksound('ph003.ogg')

question_ph[4] = 'Who was the physicist who recieved the Nobel prize in 1949 for his work on strong nuclear interactions which included the prediction of mesons?'
choice1_ph[4] = 'Richard Feynman'
choice2_ph[4] = 'John Bell'
choice3_ph[4] = 'Hideki Yukawa'
choice4_ph[4] = 'Leo Szilard'
answer_ph[4] = 3
sound_ph[4] = checksound('ph004.ogg')
