#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import pyscitriv modules
from scale import res
from esc import Esc

#initialize pygame
pygame.init()

#set some stuff according to the resolution
titlefontsize =  int(0.0825*res[0])
numfontsize = int(0.06*res[0])
itemfontsize = int(0.045*res[0])
itemspacing_y = int(.15*res[1])
numshift_x =  int(0.032*res[0])
itemshift_x =  int(0.1*res[0])
headerborder_y = int(0.125*res[1])
heightincrease = int(0.025*res[1])

#colors
white = (255,255,255)
black = (0,0,0)
yellow = (252,255,0)
green = (0,254,17)
blue = (0,160,255)

#category elements, n+1
category = [0]*16

#create the strings in the category list
category[0] = "Physics"
category[1] = "Physics History"
category[2] = "Mathematics"
category[3] = "Mathematics History"
category[4] = "Chemistry"
category[5] = "Chemistry History"
category[6] = "Astronomy"
category[7] = "Astronomy History"
category[8] = "Biology"
category[9] = "Biology History"
category[10] = "Computer Science"
category[11] = "Computer Science History"
category[12] = "Technology and Engineering"
category[13] = "Technology and Engineering History"
category[14] = "Earth Sciences"
category[15] = "Earth Sciences History"
#I'll be lumping medicine in with technology and engineering for now
#category[16] = "Medicine"
#category[17] = "Medicine History"

#number of categories
n = 15

class MakeCategoryScreen:
	def __init__(self, screen, background, who):
		self.screen = screen
		self.background = background
		self.who = who
		
		#set fonts
		titlefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		numfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', numfontsize)
		itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)

		#set categories
		self.cat1 = random.randint(0,n)
		self.cat2 = random.randint(0,n)
		if self.cat2 == self.cat1:
			while(self.cat1 == self.cat2):
				self.cat2 = random.randint(0,n)
		else: pass
		self.cat3 = random.randint(0,n)
		if self.cat3 == self.cat1 or self.cat3 == self.cat2:
			while(self.cat3 == self.cat1 or self.cat3 == self.cat2):
				self.cat3 = random.randint(0,n)
		else: pass
		
		#create surfaces
		self.title = titlefont.render("Pick a Category",1, yellow)
		self.num1 = numfont.render("1", 1, green)
		self.num2 = numfont.render("2",1, green)
		self.num3 = numfont.render("3",1, green)
		self.item1 = itemfont.render(category[self.cat1],1, white)
		self.item2 = itemfont.render(category[self.cat2],1, white)
		self.item3 = itemfont.render(category[self.cat3],1, white)
		#create rects
		self.titlerect = self.title.get_rect()
		self.num1rect = self.num1.get_rect()
		self.num2rect = self.num2.get_rect()
		self.num3rect = self.num3.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		#move rects
		self.titlerect.top += headerborder_y
		self.titlerect.centerx = screen.get_rect().centerx
		self.num1rect.left = self.num2rect.left = self.num3rect.left = self.num1rect.left + numshift_x
		self.num1rect.top = self.titlerect.top + (2*itemspacing_y)
		self.num2rect.top = self.num1rect.top + itemspacing_y
		self.num3rect.top = self.num2rect.top + itemspacing_y
		self.item1rect.left = self.item2rect.left = self.item3rect.left = self.item1rect.left + itemshift_x
		self.item1rect.centery = self.num1rect.centery
		self.item2rect.centery = self.num2rect.centery
		self.item3rect.centery = self.num3rect.centery
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.num1, self.num1rect)
		self.screen.blit(self.num2, self.num2rect)
		self.screen.blit(self.num3, self.num3rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
	
	def drawselection(self, pos):
		self.selectionrect = self.item1.get_rect()
		self.selectionrect.height += heightincrease
		self.selectionrect.centery = self.item1rect.centery
		background2 = pygame.Surface((res[0], self.selectionrect.height))
		background2.set_alpha(100)
		background2.fill(blue)
		self.selectionrect.centery = self.selectionrect.centery + itemspacing_y*(pos - 1)
		self.screen.blit(background2, self.selectionrect)
		
	def whochooses(self):
		itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', int(1.2*itemfontsize))
		if self.who == 1: choose = itemfont.render("Player 1", 1, green)
		elif self.who == 2: choose = itemfont.render("Player 2", 1, green)
		elif self.who == 3: choose = itemfont.render("Player 3", 1, green)
		chooserect = choose.get_rect()
		chooserect.top = self.screen.get_rect().top + headerborder_y*.25
		chooserect.centerx = self.screen.get_rect().centerx
		self.screen.blit(choose, chooserect)
			
class LoopCategory:
	def __init__(self, screen, background, who):
		self.backtomenu = 0
		
		mc = MakeCategoryScreen(screen, background, who)
		escape = Esc(screen, background)
	
		position = 1
		running = 1
		while (running==1):
			background.fill(black)
			screen.blit(background, (0,0))
			mc.drawselection(position)
			mc.drawscreen()
			mc.whochooses()
			pygame.display.flip()
			pygame.time.wait(10)
			
			#set mouse pos
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > mc.num1rect.top and mousepos[1] < mc.num1rect.bottom:
					position = 1
			elif mousepos[1] > mc.num2rect.top and mousepos[1] < mc.num2rect.bottom:
					position = 2
			elif mousepos[1] > mc.num3rect.top and mousepos[1] < mc.num3rect.bottom:
					position = 3
			
			for event in pygame.event.get():	
				if event.type is KEYDOWN:
					if event.key == K_1: self.categorychoice = mc.cat1; running = 0
					elif event.key == K_2: self.categorychoice = mc.cat2; running = 0
					elif event.key == K_3: self.categorychoice = mc.cat3; running = 0
					
					elif event.key == K_UP:
						position -= 1
						if position < 1: position = 3
						else: pass
					elif event.key == K_DOWN:
						position += 1
						if position > 3: position = 1
						else: pass
					
					elif event.key == K_RETURN:
						if position == 1: self.categorychoice = mc.cat1
						elif position == 2: self.categorychoice = mc.cat2
						elif position == 3: self.categorychoice = mc.cat3
						running = 0
						
					elif event.key == K_ESCAPE:
						escape.loop()	
				
				elif event.type is QUIT:
					sys.exit()
				
				elif event.type is MOUSEBUTTONDOWN:
					if position == 1: self.categorychoice = mc.cat1
					elif position == 2: self.categorychoice = mc.cat2
					elif position == 3: self.categorychoice = mc.cat3
					running = 0
						
			self.backtomenu = escape.backtomenu
			if self.backtomenu == 1: running = 0
			