#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from scale import res

#initialize pygame
pygame.init()

#colors
white = (255,255,255)
blue = (0,160,255)

class Esc:
	def __init__(self, screen, background):
		self.backtomenu = 0
		self.screen = screen
		self.background = background
		
		#font
		escmenufont = pygame.font.Font('data/fonts/FreeSansBold.ttf', int(res[0]*.03))
		#strings
		escstring1 = "press Return to quit to menu";
		escstring2 = "press Esc to return to the game"
		#surfaces
		self.esc1 = escmenufont.render(escstring1, 1, white)
		self.esc2 = escmenufont.render(escstring2, 1, white)
		#make and move rects
		self.esc1rect = self.esc1.get_rect()		
		self.esc2rect = self.esc2.get_rect()
		self.escboxw = int(.6*res[0])
		self.escboxh = int(.2*res[1])
		
		#create the blue bg rect
		self.background2 = pygame.Surface((self.escboxw, self.escboxh))
		self.background2.set_alpha(100)
		self.background2.fill(blue)
		self.escbox = pygame.Rect((0,0),(self.escboxw, self.escboxh))
		self.escbox.centerx = self.screen.get_rect().centerx
		self.escbox.centery = self.screen.get_rect().centery
		self.esc1rect.top = self.escbox.top + (.1*self.escbox.height)
		self.esc2rect.bottom = self.escbox.bottom - (.1*self.escbox.height)
		self.esc1rect.centerx = self.esc2rect.centerx = self.screen.get_rect().centerx
		
	def drawscreen(self):
		self.screen.blit(self.background2, self.escbox)
		self.screen.blit(self.esc1, self.esc1rect)
		self.screen.blit(self.esc2, self.esc2rect)
		
	def loop(self):
		self.background.fill((0,0,0))
		self.screen.blit(self.background, (0,0))
		self.drawscreen()
		pygame.display.flip()
		escrunning = 1
		while escrunning == 1:
			for event in pygame.event.get():
				if event.type is QUIT:
					sys.exit()
				
				if event.type is KEYDOWN:
					if event.key == K_ESCAPE: 
						escrunning = 0
					elif event.key == K_RETURN:
						self.backtomenu = 1
						escrunning = 0
			pygame.time.wait(10)
		
