#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from scale import res

#set sound for changing a setting
boop = pygame.mixer.Sound("data/sounds/effects/boop.ogg")

#set some things according to resolution
titlefontsize = int(res[0]*.0825)
itemfontsize = int(res[0]*.035)
itemspacing = int(res[1]*.1)

#colors
yellow = (251,254,0)
green =  (5,240,30)
white = (255,255,255)
blue = (0,160,255)
black = (0,0,0)

#initialize pygame
pygame.init()

class MakeGamesettings:
	def __init__(self, screen, background, pnum):
		self.screen = screen; self.background = background
		
		#set fonts
		titlefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		#make surfaces
		self.title = titlefont.render("Game Settings", 1, yellow)
		self.item1 = itemfont.render("Number of Players", 1, green)
		self.item2 = itemfont.render(pnum, 1, white)
		#make rects
		self.titlerect = self.title.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		#move rects
		self.titlerect.centerx = self.screen.get_rect().centerx
		self.item1rect.centerx = self.item2rect.centerx = self.screen.get_rect().centerx
		self.item1rect.centery = self.screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
	
	def drawselection(self):
		self.selectionbox = self.item1.get_rect()
		self.selectionbox.center = self.item2rect.center
		background2 = pygame.Surface((self.selectionbox.width, self.selectionbox.height))
		background2.set_alpha(100)
		background2.fill(blue)
		self.screen.blit(background2, self.selectionbox)
		
class LoopGamesettings:
	def __init__(self, screen, background):
		
		gsfile = open('settings/game.txt', 'r')
		gsfile.seek(0)
		numplayers = gsfile.readline(1)
		gsfile.close()
		
		mg = MakeGamesettings(screen, background, numplayers)
		
		running = 1
		while running == 1:
			background.fill(black)
			screen.blit(background, (0,0))
			mg.drawselection()
			mg.drawscreen()
			pygame.display.flip()
			
			mousepos = pygame.mouse.get_pos()
			position = 0
			if mousepos[0] > mg.item1rect.left and mousepos[0] < mg.item1rect.right:
				if mousepos[1] > mg.item2rect.top and mousepos[1] < mg.item2rect.bottom:
					position = 1
			
			for event in pygame.event.get():
				if event.type is MOUSEBUTTONDOWN:
					boop.play(0, 2000)
					if position ==1:
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(0)
						if numplayers == "1": gsfile.write("2")
						elif numplayers == "2": gsfile.write("3")
						elif numplayers == "3": gsfile.write("1")
						gsfile.close()
				
				if event.type is KEYDOWN :
					if event.key == K_RETURN:
						boop.play(0, 2000)
						gsfile = open('settings/game.txt', 'r+w')
						gsfile.seek(0)
						if numplayers == "1": gsfile.write("2")
						elif numplayers == "2": gsfile.write("3")
						elif numplayers == "3": gsfile.write("1")
						gsfile.close()

					elif event.key == K_ESCAPE:
						running = 0
				
				if event.type is QUIT:
					sys.exit()
				
			gsfile = open('settings/game.txt', 'r')
			gsfile.seek(0)
			numplayers = gsfile.readline(1)
			gsfile.close()
			mg = MakeGamesettings(screen, background, numplayers)
			
			pygame.time.wait(10)