#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from category import LoopCategory
from question_screen import LoopQuestion

#initialize pygame
pygame.init()

class LoopPlay:
	def __init__(self, screen, background):
		p1score = 0; p2score = 0; p3score = 0
	
		running = 1
		while (running == 1):
			gsfile = open('settings/game.txt', 'r')
			gsfile.seek(0)
			numplayers = gsfile.readline(1)
			gsfile.close()
			
			numpint = int(numplayers)
			whowillchoose = random.randint(1, numpint)
			
			#category screen
			lc = LoopCategory(screen, background, whowillchoose)
			if lc.backtomenu == 1:
				running = 0
			else:
				#go to question screen using category choice
				lq = LoopQuestion(screen, background, lc.categorychoice, p1score, p2score, p3score, numplayers)
				
				whowillchoose = lq.whowasright
				if whowillchoose == 0:
					whowillchoose = random.randint(1,numpint)
				else: whowillchoose = lq.whowasright
				
				if lq.backtomenu == 1:
					running = 0
				else:	
					p1score = lq.p1score_q
					p2score = lq.p2score_q
					p3score = lq.p3score_q
		
