#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import python modules
import os, sys, pygame, random, math
from pygame.locals import *

#import resolution from scale
from scale import res
from text_wrap import TextWrap
from set_category import SetQuestion
from esc import Esc

#set some things according to resolution
questionfontsize = int(.0325*res[0])
itemfontsize = numfontsize= int(0.041*res[0])
scorefontsize = int(0.0275*res[0])
itemspacing_y = int(.09*res[1])
numshift = int(.0625*res[0])
itemshift = 2*numshift
qshift_x = int(0.03125*res[0])
scorespacing = int(.06*res[1])

#colors
white = (255,255,255)
black = (0,0,0)
yellow = (251,254,0)
blue = (0,160,255)
green = (0,254,17)
green2 = (5,240,30)
teal = (0,255,255)
red = (255,0,0)

#set bindings for player buzzers
inputfile = open('settings/input.txt', 'r')
inputfile.seek(0); p1buzz = inputfile.readline(1)
inputfile.seek(1); p2buzz = inputfile.readline(1)
inputfile.seek(2); p3buzz = inputfile.readline(1)
inputfile.close()

#load the sound effects for the question screen
buzz = pygame.mixer.Sound("data/sounds/effects/buzz.ogg")
correct = pygame.mixer.Sound("data/sounds/effects/correct.ogg")
wrong = pygame.mixer.Sound("data/sounds/effects/wrong.ogg")

#initialize pygame
pygame.init()

class MakeQuestion:
	def __init__(self, screen, background, question, choice1, choice2, choice3, choice4, sound, numplayers):
		self.screen = screen; self.background = background
		self.question = question
		self.sound = sound
		self.choice1 = choice1; self.choice2 = choice2; self.choice3 = choice3; self.choice4 = choice4
		self.numplayers = numplayers
		
		#fonts
		self.questionfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', questionfontsize)
		self.itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		self.numfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', numfontsize)
		self.scorefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', scorefontsize)
		
		#surfaces
		self.num1 = self.numfont.render("1", 1, yellow)
		self.num2 = self.numfont.render("2", 1, yellow)
		self.num3 = self.numfont.render("3", 1, yellow)
		self.num4 = self.numfont.render("4", 1, yellow)
		self.item1 = self.itemfont.render(self.choice1, 1, green2)
		self.item2 = self.itemfont.render(self.choice2, 1, green2)
		self.item3 = self.itemfont.render(self.choice3, 1, green2)
		self.item4 = self.itemfont.render(self.choice4, 1, green2)
		#rects
		self.num1rect = self.num1.get_rect()
		self.num2rect = self.num2.get_rect()
		self.num3rect = self.num3.get_rect()
		self.num4rect = self.num4.get_rect()
		self.item1rect = self.item1.get_rect()
		self.item2rect = self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		self.item4rect = self.item4.get_rect()
		#move rects
		self.num1rect.centery = screen.get_rect().centery
		self.num2rect.top = self.num1rect.top + itemspacing_y
		self.num3rect.top = self.num2rect.top + itemspacing_y
		self.num4rect.top = self.num3rect.top + itemspacing_y
		self.num1rect.left = self.num2rect.left = self.num3rect.left = self.num4rect.left =  self.num2rect.left + numshift
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + itemspacing_y
		self.item3rect.top = self.item2rect.top + itemspacing_y
		self.item4rect.top = self.item3rect.top + itemspacing_y
		self.item1rect.left = self.item2rect.left = self.item3rect.left = self.item4rect.left = self.item1rect.left + itemshift
		
		#textwrap 
		self.tw = TextWrap(screen, background, self.question, self.questionfont)
		self.tw.line1rect.top = self.tw.line1rect.top + qshift_x
		self.tw.line1rect.left = self.tw.line1rect.left + qshift_x
		if len(self.tw.q2) >= 1:
			self.tw.line2rect.top = self.tw.line1rect.bottom
			self.tw.line2rect.left = self.tw.line1rect.left
		if len(self.tw.q3) >= 1:
			self.tw.line3rect.top = self.tw.line2rect.bottom
			self.tw.line3rect.left = self.tw.line1rect.left
		if len(self.tw.q4) >= 1:
			self.tw.line4rect.top = self.tw.line3rect.bottom
			self.tw.line4rect.left = self.tw.line1rect.left
		if len(self.tw.q5) >= 1:
			self.tw.line5rect.top = self.tw.line4rect.bottom
			self.tw.line5rect.left = self.tw.line1rect.left
		if len(self.tw.q6) >= 1:
			self.tw.line6rect.top = self.tw.line5rect.bottom
			self.tw.line6rect.left = self.tw.line1rect.left
	
	def drawscreen(self):
		self.screen.blit(self.tw.line1, self.tw.line1rect)
		#test if it is needed to blit any wrapped text
		if len(self.tw.q2) >= 1:
			self.screen.blit(self.tw.line2, self.tw.line2rect)
		if len(self.tw.q3) >= 1:
			self.screen.blit(self.tw.line3, self.tw.line3rect)
		if len(self.tw.q4) >= 1:
			self.screen.blit(self.tw.line4, self.tw.line4rect)
		if len(self.tw.q5) >= 1:
			self.screen.blit(self.tw.line5, self.tw.line5rect)
		if len(self.tw.q6) >= 1:
			self.screen.blit(self.tw.line6, self.tw.line6rect)
		#blit the numbers and possible answers
		self.screen.blit(self.num1, self.num1rect); self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.num2, self.num2rect); self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.num3, self.num3rect); self.screen.blit(self.item3, self.item3rect)
		self.screen.blit(self.num4, self.num4rect); self.screen.blit(self.item4, self.item4rect)
		
	def drawselection(self, pos):
		self.selectionrect = self.num1.get_rect()
		background2 = pygame.Surface((res[0], self.selectionrect.height))
		background2.set_alpha(100)
		background2.fill(blue)
		self.selectionrect.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
		self.screen.blit(background2, self.selectionrect)
	
	def drawcorrect(self, pos):
		self.selectionrect3 = self.num1.get_rect()
		background2 = pygame.Surface((res[0], self.selectionrect3.height))
		background2.set_alpha(100)
		background2.fill(teal)
		self.selectionrect3.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
		self.screen.blit(background2, self.selectionrect3)
	
	def drawwrong(self, w1, w2, w3, w4):
		self.selectionrect2 = self.num1.get_rect()
		background2 = pygame.Surface((res[0], self.selectionrect2.height))
		background2.set_alpha(100)
		background2.fill(red)
		if w1 == "yes":
			pos = 1
			self.selectionrect2.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
			self.screen.blit(background2, self.selectionrect2)
		if w2 == "yes":
			pos = 2
			self.selectionrect2.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
			self.screen.blit(background2, self.selectionrect2)
		if w3 == "yes":
			pos = 3
			self.selectionrect2.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
			self.screen.blit(background2, self.selectionrect2)
		if w4 == "yes":
			pos = 4
			self.selectionrect2.centery = self.num1rect.centery + itemspacing_y*(pos - 1)
			self.screen.blit(background2, self.selectionrect2)
			
	def drawscore(self, p1, p2, p3, buzzed, who):
		p1h = self.scorefont.render("Player 1", 1, white)
		p2h = self.scorefont.render("Player 2", 1, white)
		p3h = self.scorefont.render("Player 3", 1, white)	
		if buzzed == "yes":
			if who ==1: p1h = self.scorefont.render("Player 1", 1, yellow)
			elif who ==2: p2h = self.scorefont.render("Player 2", 1, yellow)
			elif who ==3: p3h = self.scorefont.render("Player 3", 1, yellow)
		else: pass
		p1text = self.scorefont.render(str(p1), 1, white)
		p2text = self.scorefont.render(str(p2), 1, white)
		p3text = self.scorefont.render(str(p3), 1, white)
		#create rects
		self.p1hrect = p1h.get_rect(); self.p2hrect = p2h.get_rect(); self.p3hrect = p3h.get_rect()
		p1box = p1text.get_rect(); p2box = p2text.get_rect(); p3box = p3text.get_rect()	
		#move rects
		self.p1hrect.top = self.p2hrect.top = self.p3hrect.top =  self.num4rect.bottom + (.5)*scorespacing
		self.p2hrect.centerx = self.screen.get_rect().centerx
		self.p1hrect.centerx = self.p2hrect.centerx - (.5)*(self.screen.get_rect().centerx)
		self.p3hrect.centerx = self.p2hrect.centerx + (.5)*(self.screen.get_rect().centerx)
		p1box.top = p2box.top = p3box.top = self.num4rect.bottom + 1.7*scorespacing
		p2box.centerx = self.screen.get_rect().centerx
		p1box.centerx = p2box.centerx - (.5)*(self.screen.get_rect().centerx)
		p3box.centerx = p2box.centerx + (.5)*(self.screen.get_rect().centerx)
		#blit the header and score rects
		self.screen.blit(p1h, self.p1hrect); self.screen.blit(p1text, p1box)
		if self.numplayers == "2":
			self.screen.blit(p1h, self.p1hrect); self.screen.blit(p1text, p1box)
			self.screen.blit(p2h, self.p2hrect); self.screen.blit(p2text, p2box)
		if self.numplayers == "3":
			self.screen.blit(p1h, self.p1hrect); self.screen.blit(p1text, p1box)
			self.screen.blit(p2h, self.p2hrect); self.screen.blit(p2text, p2box)
			self.screen.blit(p3h, self.p3hrect); self.screen.blit(p3text, p3box)
	def playquestion(self):
		if self.sound != 0:
			self.sound.play(0,0)
			print "sound should play"
	def stopquestion(self):
		if self.sound!= 0:
			self.sound.stop()
			print "sound should stop"
	
class BuzzIn:
	def __init__(self, screen, background, qobj, sq, wrong1, wrong2, wrong3, wrong4, p1s, p2s, p3s, buzz):
		self.escape = Esc(screen, background)
		self.wrong1 = wrong1; self.wrong2 = wrong2; self.wrong3 = wrong3; self.wrong4 = wrong4
		boxcounter = 1
		self.score = 0
		self.playerwas = ""
		
		buzzrunning = 1
		while buzzrunning == 1:
			mousepos = pygame.mouse.get_pos()
			if mousepos[1] > qobj.num1rect.top and mousepos[1] < qobj.num1rect.bottom:
				boxcounter = 1
			elif mousepos[1] > qobj.num2rect.top and mousepos[1] < qobj.num2rect.bottom:
				boxcounter = 2
			elif mousepos[1] > qobj.num3rect.top and mousepos[1] < qobj.num3rect.bottom:
				boxcounter = 3
			elif mousepos[1] > qobj.num4rect.top and mousepos[1] < qobj.num4rect.bottom:
				boxcounter = 4				
			background.fill((0,0,0))
			screen.blit(background, (0,0))
			qobj.drawselection(boxcounter)
			qobj.drawscore(p1s, p2s, p3s, "yes", buzz)
			qobj.drawwrong(self.wrong1, self.wrong2, self.wrong3, self.wrong4)
			qobj.drawscreen()	
			pygame.display.flip()
			pygame.time.wait(10)
								
			for event in pygame.event.get():
				if event.type is QUIT:
					sys.exit()
				
				if event.type is MOUSEBUTTONDOWN:
					if boxcounter == sq.answer:
						correct.play(0, 2000)
						self.score += 2
						self.playerwas = "correct"								
					else:
						if boxcounter == 1 and self.wrong1 == "no":
							self.wrong1 = "yes"
							self.score -= 1
							self.playerwas = "wrong"
						elif boxcounter == 2 and self.wrong2 == "no":
							self.wrong2 = "yes"
							self.score -= 1
							self.playerwas = "wrong"
						elif boxcounter == 3 and self.wrong3 == "no":
							self.wrong3 = "yes"
							self.score -= 1
							self.playerwas = "wrong"
						elif boxcounter == 4 and self.wrong4 == "no":
							self.wrong4 = "yes"
							self.score = self.score - 1
							self.playerwas = "wrong"
						wrong.play(0, 2000)	
					buzzrunning = 0

				if event.type is KEYDOWN:
					if event.key == K_ESCAPE:
						self.escape.loop()
						if self.escape.backtomenu == 1:
							mehmeh = 0
						
					if pygame.key.name(event.key) == str(sq.answer):
						correct.play(0, 2000)
						self.score = self.score + 2
						self.playerwas = "correct"
						mehmeh = 0
										
					else:
						if pygame.key.name(event.key) == "1" and self.wrong1 == "no":
							self.wrong1 = "yes"
							wrong.play(0, 2000)
							self.score = self.score - 1
							self.playerwas = "wrong"
							mehmeh = 0
						elif pygame.key.name(event.key) == "2" and self.wrong2 == "no":
							self.wrong2 = "yes"
							wrong.play(0, 2000)
							self.score = self.score - 1
							self.playerwas = "wrong"
							mehmeh = 0
						elif pygame.key.name(event.key) == "3" and self.wrong3 == "no":
							self.wrong3 = "yes"	
							wrong.play(0, 2000)
							self.score = self.score - 1
							self.playerwas = "wrong"
							mehmeh = 0
						elif pygame.key.name(event.key) == "4" and self.wrong4 == "no":
							self.wrong4 = "yes"
							wrong.play(0, 2000)
							self.score = self.score - 1
							self.playerwas = "wrong"
							mehmeh = 0
						
										
class LoopQuestion:
	def __init__(self, screen, background, categorychoice, p1s, p2s, p3s, numplayers):
		self.p1score_q = p1s; self.p2score_q =p2s; self.p3score_q = p3s
		self.numplayers = numplayers
		
		bi = "None"
		wrong1 = "no"; wrong2 = "no"; wrong3 = "no"; wrong4 = "no"
		p1try = "no"; p2try = "no"; p3try = "no"
		self.backtomenu = 0
		totaltries = 0
		answered = 0
		self.whowasright = 0
		
		sq = SetQuestion(categorychoice)
		mq = MakeQuestion(screen, background, sq.question, sq.choice1, sq.choice2, sq.choice3, sq.choice4, sq.sound, numplayers)
		mq.playquestion()
		escape = Esc(screen, background)
		
		timestart = pygame.time.get_ticks()
		esctime = 0
		
		running = 1
		while (running==1):
			background.fill(black)
			screen.blit(background, (0,0))
			mq.drawwrong(wrong1, wrong2, wrong3, wrong4)
			mq.drawscreen()
			mq.drawscore(p1s, p2s, p3s, "no", 0)
			pygame.display.flip()
			pygame.time.wait(10)
		
			timetotal = pygame.time.get_ticks()
			timedelta = timetotal - timestart + esctime
			if timedelta >= 20000:
				running = 0
			
			for event in pygame.event.get():
				if event.type is KEYDOWN:
					mq.stopquestion()
					if (pygame.key.name(event.key) == p1buzz or event.key == K_LSHIFT) and p1try == "no" and int(numplayers) >= 1:
						buzz.play(0, 2000)
						bi = BuzzIn(screen, background, mq, sq, wrong1, wrong2, wrong3, wrong4, p1s, p2s, p3s, 1)
						if bi.playerwas == "wrong":
							totaltries = totaltries + 1
							p1try = "yes"
							wrong1 = bi.wrong1; wrong2 = bi.wrong2; wrong3 = bi.wrong3; wrong4 = bi.wrong4
							p1s = p1s + bi.score
						if bi.playerwas == "correct":
							answered = 1
							p1s = p1s + bi.score
							self.whowasright = 1
						pygame.init()
						timestart = pygame.time.get_ticks()
						
					elif (pygame.key.name(event.key) == p2buzz or event.key == K_SPACE) and p2try == "no" and int(numplayers) >= 2:
						buzz.play(0, 2000)
						bi = BuzzIn(screen, background, mq, sq, wrong1, wrong2, wrong3, wrong4, p1s, p2s, p3s, 2)
						if bi.playerwas == "wrong":
							totaltries = totaltries + 1
							p2try = "yes"
							wrong1 = bi.wrong1; wrong2 = bi.wrong2; wrong3 = bi.wrong3; wrong4 = bi.wrong4
							p2s = p2s + bi.score
						if bi.playerwas == "correct":
							answered = 1
							p2s = p2s + bi.score
							self.whowasright = 2
						pygame.init()
						timestart = pygame.time.get_ticks()
							
					elif (pygame.key.name(event.key) == p3buzz or event.key == K_RSHIFT) and p3try == "no" and int(numplayers) >= 3:
						buzz.play(0, 2000)
						bi = BuzzIn(screen, background, mq, sq, wrong1, wrong2, wrong3, wrong4, p1s, p2s, p3s, 3)
						if bi.playerwas == "wrong":
							totaltries = totaltries + 1	
							p3try = "yes"
							wrong1 = bi.wrong1; wrong2 = bi.wrong2; wrong3 = bi.wrong3; wrong4 = bi.wrong4
							p3s = p3s + bi.score
						if bi.playerwas == "correct":
							answered = 1
							p3s = p3s + bi.score
							self.whowasright = 3
						pygame.init()
						timestart = pygame.time.get_ticks()
							
					elif event.key == K_ESCAPE and answered != 1 and totaltries < int(self.numplayers):
						escape.loop()
						esctime = timedelta
						pygame.init()
						timestart = pygame.time.get_ticks()
					
				if event.type is QUIT:
					sys.exit()
			if totaltries >= int(self.numplayers):
				self.p1score_q = p1s; self.p2score_q = p2s; self.p3score_q = p3s
				background.fill(black)
				screen.blit(background, (0,0))
				mq.drawwrong(wrong1, wrong2, wrong3, wrong4)
				mq.drawscreen()	
				mq.drawscore(p1s, p2s, p3s, "no", 0)
				pygame.display.flip()
				pygame.time.wait(1000)
				running = 0
			if answered == 1:
				self.p1score_q = p1s; self.p2score_q = p2s; self.p3score_q = p3s
				background.fill(black)
				screen.blit(background, (0,0))
				mq.drawcorrect(sq.answer)
				mq.drawwrong(wrong1, wrong2, wrong3, wrong4)
				mq.drawscreen()	
				mq.drawscore(p1s, p2s, p3s, "no", 0)
				pygame.display.flip()
				pygame.time.wait(1000)
				running = 0
				
			self.backtomenu = escape.backtomenu
			if self.backtomenu == 1: running = 0
			if bi != "None":
				if bi.escape.backtomenu == 1: 
					self.backtomenu = 1 
					running = 0