#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import modules
import os, sys, pygame, random, math
from pygame.locals import *

#open txt file that holds the settings to be tested for resolution and fullscreen
#seek moves around the file, so I'm seeking to character 0, then character 1
#I'm reading 1 character with readline by passing it 1
vidfile = open('settings/video.txt', 'r')
vidfile.seek(0)
a = vidfile.readline(1)
vidfile.seek(1)
b = vidfile.readline(1)
vidfile.close()	

#tests the strings loaded from the txt file to see which resolution should be used
if a == "1":
	menupic = pygame.image.load('data/graphics/logo_800x600.png')
	res = (800, 600)
elif a == "2":
	menupic = pygame.image.load('data/graphics/logo_1024x768.png')
	res = (1024, 768)
else:
	menupic = pygame.image.load('data/graphics/logo_640x480.png')
	res = (640, 480)
		
#tests if fullscreen should be used or not, windowset will be used by the main pyscitrivia file
if b == "1":
	windowset = pygame.display.set_mode(res, FULLSCREEN)
else:
	windowset = pygame.display.set_mode(res)