#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import python modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from scale import res
from inputsettings import MakeInputsettings, LoopInputsettings
from videosettings import MakeVideosettings, LoopVideosettings
from gamesettings import MakeGamesettings, LoopGamesettings

#set some things according to resolution
titlefontsize = int(0.09*res[0])
itemfontsize = int(0.0375*res[0])
verticalborder =  int(0.125*res[1])
itemspacing =  int(0.0625*res[0])

#colors
white = (255,255,255)
black = (0,0,0)
yellow = (251,254,0)
blue = (0,160,255)

#initialize pygame
pygame.init()

class MakeSettings:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#create fonts
		self.titlefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		self.itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		#create surfaces
		self.title = self.titlefont.render("Settings", 1, yellow)
		self.item1 = self.itemfont.render("Video Settings", 1, white)
		self.item2 = self.itemfont.render("Game Settings", 1, white)
		self.item3 = self.itemfont.render("Input Settings", 1, white)
		#create and move title rect
		self.titlerect = self.title.get_rect()
		self.titlerect.centerx = screen.get_rect().centerx
		self.titlerect.top += verticalborder
		#make item rects
		self.item1rect = self.item1.get_rect()
		self.item2rect= self.item2.get_rect()
		self.item3rect = self.item3.get_rect()
		#move item rects
		self.item1rect.centerx = self.item2rect.centerx = self.item3rect.centerx =  screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top= self.item1rect.top + itemspacing
		self.item3rect.top = self.item2rect.top + itemspacing
		
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		self.screen.blit(self.item3, self.item3rect)
		
	def drawselectbox(self, pos):
		self.selectionrect = self.item2.get_rect()
		self.selectionrect.centerx = self.screen.get_rect().centerx
		self.selectionrect.top = self.item1rect.top
		background2 = pygame.Surface((self.selectionrect.width, self.selectionrect.height))
		background2.set_alpha(100)
		background2.fill(blue)
		self.selectionrect.top += itemspacing*(pos-1)
		self.screen.blit(background2, self.selectionrect)
		
class LoopSettings:
	def __init__(self, screen, background):
		position = 1
		ms = MakeSettings(screen, background)
		
		running= 1
		while (running == 1):
			screen.blit(background, (0,0))
			ms.drawselectbox(position)
			ms.drawscreen()
			pygame.display.flip()
			pygame.time.wait(10)
			
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[0] > ms.item1rect.left and mousepos[0] < ms.item1rect.right:
				if mousepos[1] > ms.item1rect.y and mousepos[1] < ms.item2rect.y:
					position = 1
				elif mousepos[1] > ms.item2rect.y and mousepos[1] < ms.item3rect.y:
					position = 2
				elif mousepos[1] > ms.item3rect.top and mousepos[1] < ms.item3rect.bottom:
					position  = 3
					
			for event in pygame.event.get():
				if event.type is QUIT:
					sys.exit()
				elif event.type is MOUSEBUTTONDOWN and ms.item1rect.left and mousepos[0] < ms.item1rect.right :
						if position == 1: LoopVideosettings(screen, background)
						elif position ==2: LoopGamesettings(screen, background)
						elif position ==3: LoopInputsettings(screen, background)
							
				elif event.type is KEYDOWN:
					if event.key == K_ESCAPE: 
						running = 0
						
					elif event.key == K_UP:
						position  = position  - 1
						if position  < 1: position  = 3
						else: pass
					elif event.key == K_DOWN:
						position  = position  + 1
						if position  > 3: position  = 1
						else:pass
						
					elif event.key == K_RETURN:
						if position == 1: LoopVideosettings(screen, background)
						elif position == 2: LoopGamesettings(screen, background)
						elif position == 3: LoopInputsettings(screen, background)