#PySciTrivia
#Copyright 2005, Michael Atkinson

#This file is part of PySciTrivia.

#PySciTrivia is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#PySciTrivia is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with PySciTrivia; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#import python modules
import os, sys, pygame, random, math
from pygame.locals import *

#import from pyscitrivia modules
from scale import res

#set some things according to resolution
titlefontsize = int(0.09*res[0])
itemfontsize = int(0.045*res[0])
title2fontsize = int(0.024*res[0])
deltaheader = int(0.03125*res[1])
itemspacing = int(0.0625*res[0])

#colors
white = (255,255,255)
yellow = (251,254,0)
green = (0,254,17)
blue = (0,160,255)

#set sound effect
boopeffect = pygame.mixer.Sound("data/sounds/effects/boop.ogg")

class MakeVideosettings:
	def __init__(self, screen, background):
		self.screen = screen
		self.background = background
		
		#make fonts
		self.titlefont = pygame.font.Font('data/fonts/FreeSansBold.ttf', titlefontsize)
		self.title2font = pygame.font.Font('data/fonts/FreeSansBold.ttf', title2fontsize)
		self.itemfont = pygame.font.Font('data/fonts/FreeSansBold.ttf', itemfontsize)
		#make surfaces
		self.title = self.titlefont.render("Video Settings", 1, yellow)
		self.item1 = self.itemfont.render("Resolution", 1, green)
		self.item2 = self.itemfont.render("Fullscreen", 1, green)
		self.title2 = self.title2font.render("Restart PySciTrivia for changes to take effect", 1, white)
		#make rects
		self.titlerect = self.title.get_rect()
		self.title2rect = self.title2.get_rect()
		self.item1rect 	= self.item1.get_rect()
		self.item2rect 	= self.item2.get_rect()
		#move rects
		self.titlerect.centerx = self.title2rect.centerx = screen.get_rect().centerx
		self.title2rect.top = self.titlerect.bottom + deltaheader
		self.item1rect.centerx = self.item2rect.centerx = screen.get_rect().centerx
		self.item1rect.centery = screen.get_rect().centery
		self.item2rect.top = self.item1rect.top + 2*itemspacing
	
	def drawscreen(self):
		self.screen.blit(self.title, self.titlerect)
		self.screen.blit(self.title2, self.title2rect)
		self.screen.blit(self.item1, self.item1rect)
		self.screen.blit(self.item2, self.item2rect)
		
	def drawsettings(self, res, fs):
		self.res = res
		self.fs = fs
		
		if self.res == "0": self.res_str = "640 x 480"
		elif self.res == "1": self.res_str = "800 x 600"
		elif self.res == "2": self.res_str = "1024 x 768"
		
		if self.fs == "0": self.fs_str = "no"
		else: self.fs_str = "yes"
		
		#make surfaces
		self.itemset1 = self.itemfont.render(self.res_str, 1, white)
		self.itemset2 = self.itemfont.render(self.fs_str, 1, white)
		#make rects
		self.itemset1rect = self.itemset1.get_rect()
		self.itemset2rect = self.itemset2.get_rect()
		#move rects
		self.itemset1rect.centerx = self.itemset2rect.centerx = self.screen.get_rect().centerx
		self.itemset1rect.top = self.item1rect.top + itemspacing
		self.itemset2rect.top = self.item2rect.top + itemspacing
		#draw
		self.screen.blit(self.itemset1, self.itemset1rect)
		self.screen.blit(self.itemset2, self.itemset2rect)
		
	def drawselection(self, boxcounter):
		self.selectionbox = self.item1.get_rect()
		self.selectionbox.centerx = self.screen.get_rect().centerx
		self.selectionbox.centery = self.screen.get_rect().centery
		background2 = pygame.Surface((self.selectionbox.width, self.selectionbox.height))
		background2.set_alpha(100)
		background2.fill(blue)
		if boxcounter == 1: self.selectionbox.top += itemspacing
		else: self.selectionbox.top += 3*itemspacing
			
		self.screen.blit(background2, self.selectionbox)
			
class LoopVideosettings:
	def __init__(self, screen, background):
		position = 1
		mv = MakeVideosettings(screen, background)
		
		vsfile = open('settings/video.txt', 'r')
		vsfile.seek(0)
		a = vsfile.readline(1)
		vsfile.seek(1)
		b = vsfile.readline(1)
		vsfile.close()
		
		running = 1
		while (running == 1):
			background.fill((0,0,0))
			screen.blit(background, (0,0))
			mv.drawscreen()
			mv.drawselection(position)
			mv.drawsettings(a, b)
			pygame.display.flip()
			pygame.time.wait(10)
			
			mousepos = pygame.mouse.get_pos()
			if mousepos[0] > mv.selectionbox.left and mousepos[0] < mv.selectionbox.right:
				if mousepos[1] > mv.item1rect.y+itemspacing and mousepos[1] < mv.item1rect.y +2*itemspacing:
					position = 1
				elif mousepos[1] > mv.item2rect.y+itemspacing and mousepos[1] < mv.item2rect.y +2*itemspacing:
					position = 2
					
			for event in pygame.event.get():
				if event.type is KEYDOWN:
					
					if event.key == K_ESCAPE:
						running = 0
					elif event.key == K_UP:
						if position == 1: position = 2
						else: position -= 1
					elif event.key == K_DOWN:
						if position == 2: position = 1
						else: position += 1	
						
					elif event.key == K_RETURN:
						boopeffect.play(0, 2000)
						vsfile = open('settings/video.txt', 'r+w')
						vsfile.seek(0)
						a = vsfile.readline(1)
						vsfile.seek(1)
						b = vsfile.readline(1)
						if position == 1:
							if a == "0": vsfile.seek(0); vsfile.write("1")
							elif a == "1": vsfile.seek(0); vsfile.write("2")
							elif a == "2": vsfile.seek(0); vsfile.write("0")
						else: 
							if b == "0": vsfile.seek(1); vsfile.write("1")
							if b == "1": vsfile.seek(1); vsfile.write("0")
						vsfile.close()
							
				if event.type is MOUSEBUTTONDOWN:
					boopeffect.play(0, 2000)
					vsfile = open('settings/video.txt', 'r+w')
					vsfile.seek(0)
					a = vsfile.readline(1)
					vsfile.seek(1)
					b = vsfile.readline(1)
					if position == 1:
						if a == "0": vsfile.seek(0); vsfile.write("1")
						elif a == "1": vsfile.seek(0); vsfile.write("2")
						elif a == "2": vsfile.seek(0); vsfile.write("0")
					else:
						if b == "0": vsfile.seek(1); vsfile.write("1")
						if b == "1": vsfile.seek(1); vsfile.write("0")
					vsfile.close()
				if event.type is QUIT:
					sys.exit()
			
			vsfile = open('settings/video.txt', 'r')
			vsfile.seek(0)
			a = vsfile.readline(1)
			vsfile.seek(1)
			b = vsfile.readline(1)
			vsfile.close()		