# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 681 $
############################################################################
#    Copyright (C) 2006 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This is free software; you can redistribute it and/or modify it       #
#    under the terms of the GNU Lesser General Public License as           #
#    published by the Free Software Foundation; either version 2.1 of      #
#    the License, or (at your option) any later version.                   #
#                                                                          #
#    This software is distributed in the hope that it will be useful,      #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      #
#    Lesser General Public License for more details.                       #
#                                                                          #
#    You should have received a copy of the GNU Lesser General Public      #
#    License along with this software; if not, write to the                #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         #
############################################################################

"""
distinguish between installed program and development version

:Author: Uwe Mayer <merkosh@hadiko.de>
:Version: $Rev: 681 $

This program uses the GNU Autotools (i.e. Autoconf and Automake) for testing
system requirements, building and installing the system, respectively.
When the program gets installed various components get distributed in the
file tree so that the location of the files differ from the one in the
development tree. This must be considered in order to have the program
runable without and with installation.

This is accomplished using configure to create the file *src/defaults.py*
from the template *src/defaults.py.in* by applying the usual ``@foobar@``
substitutions.

The following variables are initialised and available from within Python:

* ``pythondir``

  usually points to *${prefix}/lib/python2.4/site-packages*; ``${prefix}`` is replaced by configure
  with */usr/local*

* ``project_dir``

  working directory of the source tree: */home/merkosh/src/python-sndfile*

* ``installdir``

  points to the location where automake will install the project
  *${prefix}/lib/python2.4/site-packages/metascan*

* ``version``

  current autoconf version number: 0.1


Modules which need to access the path of other files can import this module
and use above variables as path components.
"""
import os

from os.path import join as fjoin, exists as fexists


#-- variables
pythondir    = "${prefix}/lib/python2.4/site-packages".replace('${prefix}', "/usr/local")
installdir   = fjoin(pythondir, "metascan")

if (os.getcwd() == "/home/merkosh/src/python-sndfile/src"):
	installdir = os.getcwd() # = "."

version      = "0.1"


