/***************************************************************************/
/*   Copyright (C) 2006 by Uwe Mayer                                       */
/*   merkosh@hadiko.de                                                     */
/*                                                                         */
/*   This is free software; you can redistribute it and/or modify it       */
/*   under the terms of the GNU Lesser General Public License as           */
/*   published by the Free Software Foundation; either version 2.1 of      */
/*   the License, or (at your option) any later version.                   */
/*                                                                         */
/*   This software is distributed in the hope that it will be useful,      */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      */
/*   Lesser General Public License for more details.                       */
/*                                                                         */
/*   You should have received a copy of the GNU Lesser General Public      */
/*   License along with this software; if not, write to the                */
/*   Free Software Foundation, Inc.,                                       */
/*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         */
/***************************************************************************/

#include "pysndfile.h"


PyObject *pysf_command(SNDFILE *sndfile, int cmd) { 
  PyObject *o = 0;

  switch (cmd) {
  case SFC_GET_LIB_VERSION: 	// (string)
  case SFC_GET_LOG_INFO:	// (string)
    char buf[2048];
    int length;
    length = sf_command(sndfile, cmd, buf, sizeof(buf));
    o = PyString_FromStringAndSize(buf, length);
    break;

  case SFC_CALC_SIGNAL_MAX:	// (double)
  case SFC_CALC_NORM_SIGNAL_MAX: // (double)
    double dvalue;
    if (sf_command(sndfile, cmd, &dvalue, sizeof(dvalue)) != 0) break;
    o = PyFloat_FromDouble(dvalue);
    break;

  case SFC_GET_NORM_FLOAT:	// (bool)
  case SFC_GET_NORM_DOUBLE:	// (bool)
  case SFC_GET_CLIPPING:	// (bool)
    o = Py_False;
    if (sf_command(sndfile, cmd, 0, 0) == SF_TRUE) o = Py_True;
    Py_INCREF(o);
    break;

  case SFC_GET_SIMPLE_FORMAT_COUNT: // (always 0)
  case SFC_GET_FORMAT_MAJOR_COUNT: // (always 0)
  case SFC_GET_FORMAT_SUBTYPE_COUNT: // (always 0)
    int ivalue;
    sf_command(sndfile, cmd, &ivalue, sizeof(ivalue));
    o = PyInt_FromLong(ivalue);
    break;

  case SFC_UPDATE_HEADER_NOW:	// (always 0)
    sf_command(sndfile, cmd, 0, 0);
    o = Py_None;
    Py_INCREF(o);
    break;

  default:
    PyErr_SetString(PyExc_ValueError, "unsupported command");
    break;
  }

  return o;
}


PyObject *pysf_command(SNDFILE *sndfile, int cmd, long long value) {
  PyObject *o = 0;

  switch (cmd) {
  case SFC_CALC_MAX_ALL_CHANNELS: // (tuple of doubles)
  case SFC_CALC_NORM_MAX_ALL_CHANNELS: // (tuple of doubles)
    double *data;
    data = new double[value];
    if (sf_command(sndfile, cmd, data, value*sizeof(double)) != 0) {
      delete[] data;
      o = Py_None;
      Py_INCREF(o);
      break;
    }
    o = PyTuple_New(value);
    for (int i=0; i < value; i++) 
      if (PyTuple_SetItem(o, i, PyFloat_FromDouble(data[i])) != 0) {
	Py_DECREF(o);
	delete[] data;
	o = Py_None;
	Py_INCREF(o);
	break;
      }
    delete[] data;
    break;

  case SFC_SET_NORM_FLOAT:	// (boolean)
  case SFC_SET_NORM_DOUBLE:	// (boolean)
  case SFC_SET_SCALE_FLOAT_INT_READ: // (boolean)
  case SFC_SET_ADD_PEAK_CHUNK:	// (boolean)
				// returns inverted value (to the documentation)
				// adds always peak value
  case SFC_SET_UPDATE_HEADER_AUTO: // (boolean)
  case SFC_SET_CLIPPING:	// (boolean)
    o = Py_False;
    if (sf_command(sndfile, cmd, 0, value) == SF_TRUE) o = Py_True;
    Py_INCREF(o);
    break;

  case SFC_FILE_TRUNCATE:	// (zero on success)
  case SFC_SET_RAW_START_OFFSET: // (zero on success)
    o = Py_False;
    if (sf_command(sndfile, cmd, &value, sizeof(value)) == 0) o = Py_True;
    Py_INCREF(o);
    break;

  default:
    PyErr_SetString(PyExc_ValueError, "unsupported command");
    break;
  }

   return o;
}


PyObject *pysf_command(SNDFILE *sndfile, int cmd, SF_FORMAT_INFO *info) {
  PyObject *o = 0;

  switch (cmd) {
  case SFC_GET_FORMAT_INFO:	// (sf_command error code)
  case SFC_GET_FORMAT_MAJOR:	// (0 or random int)
  case SFC_GET_FORMAT_SUBTYPE:	// (0 or random int)
    o = PyInt_FromLong(sf_command(sndfile, cmd, info, sizeof(SF_FORMAT_INFO)));
    break;

  default:
    PyErr_SetString(PyExc_ValueError, "unsupported command");
    break;
  }

  return o;
}


PyObject *pysf_command(SNDFILE *sndfile, int cmd, SF_EMBED_FILE_INFO *info) {
  PyObject *o = 0;

  switch (cmd) {
  case SFC_GET_EMBED_FILE_INFO:
    o = Py_False;
    if (sf_command(sndfile, cmd, info, sizeof(SF_EMBED_FILE_INFO)) == 0) o = Py_True;
    Py_INCREF(o);
    break;

  default:
    PyErr_SetString(PyExc_ValueError, "unsupported command");
    break;
  }
 
  return o;
}
