#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.26
Release:	1
Requires:	coreutils diffutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://www.zip.com.au/~akpm/linux/patches/.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
./configure
make prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/lib/quilt/
/etc/bash_completion.d/quilt
%doc %{_mandir}/man1/guards.1.gz
%doc %{_docdir}/%{name}-%{version}/README

%changelog
* Tue Oct 21 2003 - agruen@suse.de
- Add `quilt fork' command.
- Add `quilt snapshot' command and `quilt diff --snapshot' option.
- Bump the version number to 0.26.
* Tue Sep  9 2003 - martin.quinson@tuxfamily.org
- fix LC_ALL to C during building the reference so that the 
  documentation comes to english and not to french when build 
  on my box.
- Update the french translation
- Bump the version number to 0.25
* Tue Sep  2 2003 - agruen@suse.de
- Pipe rpmbuild output to /dev/null in spec2series (seems to be
  necessary since rpm4).
* Mon Jul 28 2003 - agruen@suse.de
- Use %{find_lang} macro in spec file.
* Sat Jul 26 2003 - agruen@suse.de
- Pushing is only possible if the topmost file is found in the
  series file. Fix from Tom Wang <wangdi@clusterfs.com>.
* Sat Jul 26 2003 - agruen@suse.de
- When popping files, go through the list of applied patches
  instead of looking at the series file: The series file may
  have changed.
* Sat Jul 26 2003 - agruen@suse.de
- Install package documentation into $RPM_DOC_DIR if this
  environment variable is set.  On RedHat 9 $RPM_DOC_DIR points to
  /usr/share/doc/packages, but documentation lives in
  /usr/share/doc.  This is a bug in RedHat's RPM configuration;
  working around it would break other distributions.
* Wed Jul 23 2003 - agruen@suse.de
- Add Autoconf test for rpmbuild vs. rpm (needed for `make rpm').
- Update spec2series accordingly.
* Sun Jul 20 2003 - agruen@suse.de
- lib/backup-files.c: Copy files if hard linking is not possible,
  e.g., because the backups go to a ram disc, etc.

