<%
' functions.php
' Copyright (C) 2007,2008 Robert Alex Marder
' This file is part of RAM-CMS
'
' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 3
' of the License, or (at your option) any later version.
'
' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software Foundation, Inc.,
' 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
' or see <http://www.gnu.org/licenses/>.
'
' This file contains all the functions used by RAM-CMS.
' The RAM-CMS function library.
'


' Purpose: determine wwhen the requested page was last updated, and format as string.
' Santax: str $updated_show = ramcms_last_update_time ( str $page )
' Where: 
' $updated_show is the last update time as a date string, or 'unknown'.
' $page is the page requested.
'
Function ramcms_last_update_time(page)
	' get the last updated time from the file of the page we want.
	' we check the file creation/change time and the file modified time and 
	' take the newer of the two. This way we have foolproof last update time.
	' the latest update time of the requested file gets put in [[updated]].
	
	Set fp=FS.GetFile(Server.MapPath(page))
	' TODO: the following isn't working for some reason - tofix
	' get the file modification time.
	'filemtime=fp.DateLastModified(page)
	' get the file creation time.
	'filectime=fp.DateCreated(page)
	
	Set fp=Nothing
	
	' determine if file creation time or file modified time is newer (higher)
	If filectime > filemtime Then
		' file creation time is newer.
		updated=filectime
	Else
		' file modification time is newer.
		updated=filemtime
	End If
	
	' if for some reason we failed to figure out when we were last 
	' updated, fix $updated_show to be "unknown" as opposed 
	' to nothing.
	' if we did figure out what the last update was, convert 
	' $updated_show from a UNIX timestamp into something humans 
	' prefer to read.
	If updated="" Then
		updated_show="unknown"
	Else
		' format example: 28 Sep 2007
		' TODO: make the date format configurable in config.php
		'updated_show=date('d M Y',updated)
		updated_show=Day(updated) & Left(MonthName(Month(updated)),3) & Year(updated)
	End If
	
	' return the last update time of the file, to be put into [[updated]].
	ramcms_last_update_time=updated_show
End Function

' Purpose: to output http headers based on a set of criteria
' Santax: null ramcms_send_http_headers ( bool $nocache )
' Where: 
' $nocache is if we should send anti-cache headers.
'
Function ramcms_send_http_headers(nocache)
	' send some http headers.
	
	' please leave this here.
	Response.AddHeader "X-CMS", "RAM-CMS"
	
	If nocache=true Then
		Response.AddHeader "Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0"
		Response.AddHeader "Expires", "Mon, 26 Jul 1997 05:00:00 GMT"
		Response.AddHeader "Pragma", "no-cache"
	Else
		' cache content for 1 hour.
		Response.AddHeader "Cache-Control", "max-age=3600, proxy-revalidate"
		' only browsers may cache this.
		Response.AddHeader "Pragma", "private"
	End If
End Function

' Purpose: to strip unwanted whitespace from $body so as to reduce bandwidth.
' Santax: str $body = ramcms_remove_body_whitespace ( str $body )
' Where: 
' $body is the $body of the requested page.
'
Function ramcms_remove_body_whitespace(body)
	' using strstr twice is faster than using one regex (I think).
	
	' if <PRE> or <pre> is found in $body then preserve whitespace.
	' otherwise remove all tabs and newlines.
	If Instr(body,"<PRE")=0 & Instr(body,"<pre")=0 & Instr(body,"<TEXTAREA")=0 & Instr(body,"<textarea")=0 Then
		' strip all newlines and tabs.
		body=Replace(Replace(Replace(body,Chr(13),""),Chr(10),""),Chr(9),"")
	End If
	ramcms_remove_body_whitespace=body
End Function

' Purpose: to replace [[string]] items with specific $string equivalents.
' Santax: 
' Where: 
'
Function ramcms_page_template_parser(page_template,title,site_name,header,updated_show,body,copyright)
	' parse the $page_template information.
	page_template=Replace(page_template,"[[body]]",body)
	page_template=Replace(page_template,"[[copyright]]",copyright)
	page_template=Replace(page_template,"[[header]]",header)
	Set fp=FS.OpenTextFile(Server.MapPath("nav.txt"),1)
	page_template=Replace(page_template,"[[nav]]",fp.ReadAll)
	Set fp=Nothing
	page_template=Replace(page_template,"[[site]]",site_name)
	page_template=Replace(page_template,"[[title]]",title)
	page_template=Replace(page_template,"[[updated]]",updated_show)
	page_template=Replace(page_template,"[[ver]]","0.2.0")
	
	ramcms_page_template_parser=page_template
End Function

' Purpose: to parse BBCode tags in $body.
' Santax: str $body = ramcms_bbcode_parser ( str $body )
' Where: 
' $body is the $body of the requested page.
'
Function ramcms_bbcode_parser(body)
	' TODO: make a better BBCode parser.
	
	' bold
	body=Replace(body,"[b]","<b>")
	body=Replace(body,"[/b]","</b>")
	
	' italics
	body=Replace(body,"[i]","<i>")
	body=Replace(body,"[/i]","</i>")
	
	' underline
	body=Replace(body,"[u]","<u>")
	body=Replace(body,"[/u]","</u>")
	
	' strikethrough
	body=Replace(body,"[s]","<strike>")
	body=Replace(body,"[/s]","</strike>")
	
	' teletype
	body=Replace(body,"[tt]","<tt>")
	body=Replace(body,"[/tt]","</tt>")
	
	' preformatted text
	body=Replace(body,"[pre]","<pre>")
	body=Replace(body,"[/pre]","</pre>")
	
	' subscript
	body=Replace(body,"[sub]","<sub>")
	body=Replace(body,"[/sub]","</sub>")
	
	' superscript
	body=Replace(body,"[sup]","<sup>")
	body=Replace(body,"[/sup]","</sup>")
	
	' big
	body=Replace(body,"[big]","<big>")
	body=Replace(body,"[/big]","</big>")
	
	' small
	body=Replace(body,"[small]","<small>")
	body=Replace(body,"[/small]","</small>")
	
	' horizontal rule
	body=Replace(body,"[hr]","<hr>")
	
	' center
	body=Replace(body,"[center]","<center>")
	body=Replace(body,"[/center]","</center>")
	
	' paragraphs
	body=Replace(body,"[p]","<p>")
	body=Replace(body,"[/p]","</p>")
	
	' line breaks
	body=Replace(body,"[br]","<br>")
	
	' list items
	body=Replace(body,"[li]","<li>")
	body=Replace(body,"[/li]","</li>")
	
	' unordered lists
	body=Replace(body,"[ul]","<ul>")
	body=Replace(body,"[/ul]","</ul>")
	
	' ordered lists
	body=Replace(body,"[ol]","<ol>")
	body=Replace(body,"[/ol]","</ol>")
	
	' headings
	'body=preg_replace('/\[h([1-6])\](.+)\[\/h([1-6])\]/U','<h${1}>${2}</h${1}>',$body);
	
	'### Complex BBCode ###
	
	' handles [url]http://example.com/blah..[/url]
	'body=preg_replace('/\[url\](.+)\[\/url\]/U','<a href="${1}">${1}</a>',$body);
	
	' handles [url=http://example.com/blah..]Click Blah[/url]
	'pattern='/\[url=(.+)\](.+)\[\/url\]/U';
	'replacement='<a href="${1}">${2}</a>';
	'body=preg_replace($pattern,$replacement,$body);
	
	' handles [color=colorname]text here[/color]
	'body=preg_replace('/\[color=(.+)\](.+)\[\/color\]/U','<font color="${1}">${2}</font>',$body);
	
	' handles [img=imagefile]
	'body=preg_replace('/\[img=(.+)\]/U','<img alt="" src="${1}">',$body);
	
	' handles [!-- this is a comment --]
	'body=preg_replace('/\[!--(.+)--]/U','',$body);
	
	ramcms_bbcode_parser=body
End Function

%>