use strict;
use vars qw($curdir $compress $pages_dir $def_page $ext $nocache $bbcode $strip_whitespace $site_name $copyright $keywords $description $theme_file);
### Core Settings ###

# should we attempt to compress the output of this program (gzip, deflate)?
# only takes effect for clients that support 
# Content-Encoding: gip or Content-Encoding: deflate
# For whitespace compression see $strip_whitespace
# default: 1
$compress=1;

# "pages" directory.
# if you're running under mod_perl this must be an absolute path.
# change to:
# $pages_dir=$curdir.'pages/'; if running on mod_perl
# default: ./pages/
$pages_dir='./pages/';

# default page to show.
# default: home
$def_page='home';

# page file extension.
# default: .txt
$ext='.txt';

# should we always prevent the client from caching the pages generated by 
# RAM-CMS?
# default: 0
$nocache=0;

# should we parse the $body of requested pages for BBCode?
# Note: this feature is still experimental!
# Note: enabling this incurs a performance penalty.
# default: 0
$bbcode=0;

# should we strip whitespace to save bandwidth?
# if your server is overloaded turning this off might help 
# performance.
# default: 1
$strip_whitespace=1;

# what is the name of your site?
# set this to the name of your organization, company, topic, etc.
# this text is represented by the [[site]] tag in the templates, 
# where the <title> is page_name - site_name
# it is highly suggested that you change this!
# default: 'My Site'
$site_name='My Site';

# copyright message to show on site.
# appears in site templates at the [[copyright]] tag.
# it is highly suggested that you change this!
# default: 'Copyright &copy; 2008 Name_Of_Copyright_Holder.'
$copyright='Copyright &copy; 2008 Name_Of_Copyright_Holder.';

# search engine keywords
# default: 
$keywords='';

# search engine description
# default: 
$description='';

### Optional Settings ###

# here is where custom config settings can go...if you are so inclined.

#####################
### Page Template ###
#####################

# specifies the theme file.
# if you need legacy traditional theme support for advanced features or 
# whatever then use something like this:
# include('themes/themename-theme.php');

#$theme_file='advertising-theme.txt';
#$theme_file='aqueous-theme.txt';
#$theme_file='blackwhite-theme.txt';
#$theme_file='centerstage-theme.txt';
#$theme_file='clementine-theme.txt';
#$theme_file='foundation-theme.txt';
#$theme_file='limegreen-theme.txt';
#$theme_file='mrtechie-theme.txt';
#$theme_file='newsprint-theme.txt';
$theme_file='ramnet-theme.txt';
#$theme_file='slashblog-theme.txt';
#$theme_file='warped-theme.txt';

1;
