#!/usr/bin/perl -w
use strict; use Time::HiRes qw(gettimeofday tv_interval); use CGI qw(param);
# lets time this thing.
my $start_time=[gettimeofday];

# Legal Stuff:
# RAM-CMS - Really Amazing Modest Content Management System.
# Copyright (C) 2007,2008 Robert Alex Marder.
# E-Mail: ralexwebs@inbox.com
# WWW: http://www.nongnu.org/ram-cms/
# Version: 0.2.0
# This is the official Perl port of RAM-CMS.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# or see <http://www.gnu.org/licenses/>.

use vars qw($curdir $compress $pages_dir $def_page $ext $nocache $bbcode $strip_whitespace $site_name $copyright $theme_file);
use vars qw($page $page_template $ext $updated_show $title $header $body $end_time);
$curdir='./'; # the current directory, default the variable.

#### CHANGE THIS IF YOU ARE RUNNING THIS VIA MOD_PERL ############################
# if you are running under mod_perl you must change this to the 
# root of the RAM-CMS installation.
# note: if you are running under mod_perl, you must touch the index.pl file 
# to make the server read-read this.
if(defined($ENV{'MOD_PERL'}) or defined($ENV{'MOD_PERL2'}))
{ $curdir='/var/www/dev.lan/ram-cms/'; }
##################################################################################

if(defined(param('page')))
{
	$page=param('page');
}

require $curdir.'config.pl';
require $curdir.'functions.pl';

# include the $theme_file so we have a template to work with.
# if $theme_file isn't defined in config.pl, or if the $theme_file 
# doesn't exist, then return HTTP 500 Error.
if(defined($theme_file) && $theme_file ne '')
{
	$page_template=RAMCMS::file_get_contents($curdir.'themes/'.$theme_file);
	#undef($theme_file);
}
else
{
	$nocache=1;
	print "Status: 500\r\n";
	RAMCMS::ramcms_send_http_headers($nocache);
	print "Fatal Error: Unable To Find / Open / Read Theme File.";
	exit;
}

### START MAIN PROGRAM ###

# if $page ends with a / character then append $def_page to it and set it to $page
# this allows home pages to work in subdirectories off of pages/ directory.
if(defined($page) and substr($page,-1) eq '/')
{
	$page=$page.$def_page;
}

# if $page is not set or empty string, we should assume the $def_page is what 
# we want to show.
if(!defined($page) or $page eq '')
{
	$page=$def_page;
}
#undef($def_page);

# TODO: Port this to Perl
# quick compression (gzip, deflate, none) if supported by PHP and client.
#if($compress==true && function_exists('ob_gzhandler')==true && function_exists('ob_start')==true)
#{
#	ob_start('ob_gzhandler');
#}
#undef($compress);

# determine whether we should return 404 page.
# if $page include .. or if $page starts with a / then we will return 404 as a security measure.
#if(file_exists($pages_dir.$page.$ext)==false || strstr($page,'..')!=false || substr($page,0,1)=='/')
if(index($page,'..')!=-1 || substr($page,0,1) eq '/' || (!open(FH,$pages_dir.$page.$ext)))
{
	$page='404';
}
else
{
	close(FH);
}

# if the page wasn't found return HTTP 404 Not Found and don't cache.
if($page eq '404')
{
	print "Status: 404\r\n";
	$nocache=1;
}

# determine last time page was updated.
$updated_show=RAMCMS::ramcms_last_update_time($pages_dir.$page.$ext);

# page requested is not a program, but a standard static page.
# format it as required.
open(FH,$pages_dir.$page.$ext) || exit("Error: unable to open page: ".$page);
undef($page); #undef($ext); undef($pages_dir);
my @raw_datain=<FH>;
close(FH);
# grab the title, always the first line.
$title=shift(@raw_datain);
# grab the header, always second line.
$header=shift(@raw_datain);

# grab body, line three till EOF
my $line='';
$body='';
foreach $line (@raw_datain)
{
	$body=$body.$line;
}
undef(@raw_datain); undef($line);

# send HTTP headers
RAMCMS::ramcms_send_http_headers($nocache);
undef($nocache);

# start parsing the template and filling in as needed.
if($bbcode==1)
{
	RAMCMS::ramcms_bbcode_parser(\$body);
}
#undef($bbcode);
if($strip_whitespace==1)
{
	RAMCMS::ramcms_remove_body_whitespace(\$body);
}

RAMCMS::ramcms_page_template_parser(\$page_template,$title,$site_name,$header,$updated_show,$body,$copyright,$curdir);

#undef($keywords);
#undef($description);
undef($title);
#undef($site_name);
undef($header);
undef($updated_show);
undef($body);
#undef($copyright);

# finish off the page timer.
$end_time=[gettimeofday];
$page_template=RAMCMS::str_replace('[[gen_time]]',tv_interval($start_time,$end_time),$page_template);
undef($end_time); undef($start_time);

if($strip_whitespace==1)
{
	RAMCMS::ramcms_remove_body_whitespace(\$page_template);
}
#undef($strip_whitespace);

# dump the entire page to the server, for sending to client.
print $page_template;
undef($page_template);
