#! /bin/bash

#
#	Simple script for running build commands for ramemu.
#

echo "Checking for the autotools..."
(autoconf --version) < /dev/null > /dev/null 2>&1 || {
   echo -e "autoconf is not properly installed on your system." \
   	"\nSee README.CVS for more information."
   exit -1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
   echo -e "automake is not properly installed on your system." \
   	"\nSee README.CVS for more information."
   exit -1
}


echo "Running aclocal..."
aclocal || exit $?
echo "Running automake..."
automake --gnu -a || exit $?
echo "Running autoconf..."
autoconf || exit $?
echo "Running the configure script..."
./configure "$@" || exit $?
echo "Running make..."
make clean all || exit $?
echo \
   "---------------------------------------------------------------------------"
echo \
   "  Build process complete.  Now you can use \`make install' to install it."
echo "    If you change anything in the package, use \`make' to rebuild it. "
