# !/bin/bash

#
#	Prepare everything for DJGPP build.
#
#	Note:  you have to run it from the root of the package source tree
#	_after_ it is built, because some files used in this build are not
#	generated here.
#
#	CAUTION:  any old files in the directory you specify as the parameter
#	for this script may be overwritten!
#

function usage
{
   echo "USAGE:  $0 <dos_build_directory_name>"
}

if [ -z "$1" ];  then
   usage
   exit 1
fi

if [ ! -d $1 ];  then
   echo "\`$1' is not a directory or does not exist."
   exit -1
fi

DIR=$1
SRCDIR=$DIR/src
OURDIR=`dirname $0`

if [ ! -d $SRCDIR ];  then
   mkdir $SRCDIR
   if [ "$?" != "0" ];  then
      echo "Could not create $SRCDIR directory."
      exit -4
   fi
fi

# Set proper version and bugreport information
VERSION=`./version.sh`
BUGREPORT=`./bugreport_address.sh`
sed -e "s/@PACKAGE_VERSION@/\"$VERSION\"/" \
	-e "s/@PACKAGE_BUGREPORT@/\"$BUGREPORT\"/" $OURDIR/src/config.h.in > \
				$OURDIR/src/config.h

cp $OURDIR/src/Makefile.in $OURDIR/src/Makefile

# Add DJGPP artifacts
cp $OURDIR/Makefile $DIR
cp $OURDIR/src/Makefile $OURDIR/src/*.[ch] $DIR/src

# Copy the sources
cd src
cp *.h $SRCDIR
cp debugger.c	$SRCDIR
# cp error.c	$SRCDIR
cp configuration.c	$SRCDIR/configtn.c
cp configuration_scanner.c	$SRCDIR/conf_scn.c
cp verbosity.c	$SRCDIR/verbsty.c
cp legal_attributes.c	$SRCDIR/leg_attr.c
cp ram_memory.c	$SRCDIR/ram_mem.c
cp debugger_interface.c	$SRCDIR/dbg_int.c
cp interface.c	$SRCDIR/interfce.c
cp ram.c	$SRCDIR
cp ram_emulator.c	$SRCDIR/ram_emlt.c
cp ram_expressions.c	$SRCDIR/ram_expr.c
cp ram_parser.c	$SRCDIR/ram_prsr.c
cp ram_text.c	$SRCDIR/ram_txt.c
cp ram_config.c	$SRCDIR/ram_cfg.c
cp read_line.c	$SRCDIR/rd_line.c
cp str_read.c	$SRCDIR/str_read.c

# Simple workaround for absent <stdint.h>

touch $SRCDIR/stdint.h

# Simple workarond for absent *snprintf functions

sed -e "s/\ snprintf;/\ gmp_snprintf;/" \
	-e "s/\ vsnprintf;/\ gmp_vsnprintf;/" error.c > $SRCDIR/error.c

# Copy the examples directory tree

cd ..

cp -R examples $DIR
