/*
 * 	Random Access Machine.
 * 	Header for the configuration and options file parser module.
 *
 * 	Copyright (C) 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __configuration_h
#define __configuration_h

#include <stdio.h>
#include <stdlib.h>

// Options are stored in the sorted doubly linked list.  
typedef struct _Conf_Option
{
   char *name, *value;
   struct _Conf_Option *previous, *next;
}
Conf_Option;

//
// Note: `option' means pointer to some option;  `configuration' --
// to the head of the options list, or pointer to pointer to the configuration.
// 
// `configuration_insert' function doesn't copy its arguments, it links them
// only, so they have to be valid pointers to memory allocated by stdlib malloc
// family functions, in order conf_delete_* could free it.
//

Conf_Option *conf_read (FILE *f);
int conf_write (const char *comment, Conf_Option *configuration, FILE *f);

void conf_insert (Conf_Option **configuration, char *name, char *value);

const char *conf_find (Conf_Option *configuration, const char *option);
int conf_scanf (Conf_Option *configuration, const char *option,
				const char *format, ...);

void conf_delete_option (Conf_Option **configuration, Conf_Option *option);
void conf_delete (Conf_Option *configuration);

Conf_Option *conf_option_new ();
void conf_option_delete (Conf_Option *);

// Private stuff

char *conf_build_string (const char *);
char *conf_build_unquoted_string (const char *);

#endif /* __configuration_h */
