/*
 * 	Random Acess Machine.
 * 	Header for various debugger stuff.
 *
 * 	Copyright (C) 2002, 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __debugger_h
#define __debugger_h

#include "ram.h"

typedef enum
{
   RAM_DEBUG_INTERRUPT,
   RAM_DEBUG_TRACING,
   RAM_DEBUG_BREAKPOINT,
   RAM_DEBUG_CATCHPOINT
}
RAM_Debug_InterruptReason;

typedef struct _RAM_Watchpoint
{
   char *expression;
   struct _RAM_Watchpoint *next;
}
RAM_Watchpoint;

typedef struct _RAM_Catchpoint
{
   char *expression;
   int index;
   int is_ignored;	// If this catchpoint was already triggered and
   			// is active still.
   struct _RAM_Catchpoint *next;
}
RAM_Catchpoint;

typedef struct
{
   RAM *machine;

   FILE *input, *output;	// Used only on new machine creation.
   
   RAM_Text *text;

   int is_running;	// If the program is running, i.e. it have
   			// a valid instruction to perform next, and
			// there were no terminating actions, such as
			// [-1] dereference, or "halt" instruction.

   int is_stopped;	// If the program is stopped, i.e. its execution
   			// was interrupted.
   RAM_Debug_InterruptReason interrupt_reason;
   int interrupt_reason_parameter;	// Index of breakpoint or catchpoint
   					// if `interrupt_reason' was one of
					// these.

   int bypass_breakpoint;	// `True' if current instruction has breakpoint
   				// which was already met.
   
   unsigned int *breakpoint;	// This array is sorted.
   unsigned int breakpoints;
   
   RAM_Watchpoint *watchpoints;	// Linked list of watchpoints.
   RAM_Catchpoint *catchpoints;	// Linked list of catchpoint.

   char *previous_command;	// For command repetition.
   				// This pointer owns its string.
}
RAM_Debug;

RAM_Debug *ram_debug_new ();
void ram_debug_only_delete (RAM_Debug *);

RAM_Debug *ram_debug_new_by (RAM *rm, FILE *input, FILE *output,
				RAM_Text *text);

int ram_debug (RAM_Debug *rd);
int ram_debug_by (RAM *rm, FILE *input, FILE *output, RAM_Text *text);

// Options management

const char *ram_debug_set_history_file (const char *);
int ram_debug_set_history_max (int);

// These functions should be private

void ram_close_program (RAM_Debug *);

void ram_disable_watchpoint (RAM_Debug *, RAM_Watchpoint *);

unsigned int *find_breakpoint (RAM_Debug *, unsigned int);

RAM_Watchpoint *add_watchpoint (RAM_Debug *, const char *);

RAM_Catchpoint *add_catchpoint (RAM_Debug *, const char *);

int instruction_by_line (RAM_Debug *, int);
int inline line_by_instruction (RAM_Debug *, int);

void inline ram_debug_reset_machine (RAM_Debug *);

int emulation_step (RAM_Debug *);

#endif /* __debugger_h */
