/*
 * 	Random Access Machine.
 * 	Header for the library module.
 *
 * 	Copyright (C) 2002, 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ram_h
#define __ram_h

#include <stdio.h>
#include <stdlib.h>
#include <gmp.h>

#include "verbosity.h"
#include "error.h"

#include "ram_memory.h"
#include "ram_text.h"

// Order is important
typedef enum
{
   RAM_NONE = 0,
   RAM_READ, RAM_WRITE,
   RAM_LOAD, RAM_STORE,
   RAM_ADD, RAM_NEG, RAM_HALF,
   RAM_JUMP, RAM_JGTZ,
   RAM_HALT
}
RAM_InstructionType;

typedef enum
{
   RAM_NO_PARAMETER, RAM_CONSTANT, RAM_POINTER, RAM_INDIRECT_POINTER,
   RAM_INSTRUCTION
}
RAM_ParameterType;

typedef struct
{
   RAM_InstructionType instruction;
   RAM_ParameterType parameter_type;
   mpz_t parameter;
}
RAM_Instruction;

typedef struct
{
   RAM_Instruction **instructions;
   unsigned int n;	// Number of instructions in the program
}
RAM_Program;

typedef struct
{
   RAM_Program *program;

   FILE *input, *output;

   RAM_Memory *memory;

   unsigned int current_instruction;
   
   mpz_t instructions_done, time_consumed;
}
RAM;

// The very basic stuff

RAM_Instruction *ram_instruction_new ();
void ram_instruction_delete (RAM_Instruction *);

RAM_Program *ram_program_new ();
void ram_program_delete (RAM_Program *);

RAM *ram_new ();

void ram_clear (RAM *);
void ram_delete (RAM *);

void ram_reset (RAM *);

// Parsing stuff

RAM_Program *ram_program_parse (FILE *f, RAM_Text *text);
RAM *ram_new_by_program (RAM_Program *);

// Emulation stuff

int ram_do_instruction (RAM *);
inline int ram_is_running (RAM *);

// IO prompts

void ram_enable_IO_prompts ();
void ram_disable_IO_prompts ();

// Private stuff  --  do not rely on it

int ram_evaluate_expression (RAM *, char *, mpz_t *);
int ram_display_expression (RAM *machine, char *prefix,
				char *expression, FILE *output, ...);

#endif /* __ram_h */
