/*
 * 	Random Access Machine.
 * 	Header for the RAM memory module.
 *
 * 	Copyright (C) 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ram_memory_h
#define __ram_memory_h

#include <stdio.h>
#include <stdlib.h>
#include <gmp.h>

// We store memory segments in an AVL tree.
// See Knuth section 6.2.3 for details of the method.
typedef struct _RAM_AVL_Node
{
   mpz_t begin, end;
   unsigned int size;	// Of the segment

   mpz_t *segment;

   int balance;	

   struct _RAM_AVL_Node *left, *right, *up;
}
RAM_AVL_Node;

typedef struct
{
   unsigned int block_size;	// Default block size
   RAM_AVL_Node *root, *begin,	// *begin contains [0], so it is useful
   				// to keep it here.
		*cache;		// Last accessed segment, or maybe NULL.

   unsigned int allocated,	// Total number of allocated registers
   		segment_count;	// Total number of segments in the tree
}
RAM_Memory;

RAM_Memory *ram_memory_new ();
void ram_memory_delete (RAM_Memory *);

void ram_memory_reset (RAM_Memory *);

inline mpz_t *ram_try_to_get_register (RAM_Memory *memory, mpz_t *addr);

inline mpz_t *ram_get_register_0 (RAM_Memory *memory);

mpz_t *ram_get_register (RAM_Memory *memory, mpz_t *addr);
inline mpz_t *ram_get_register_by_pointer (RAM_Memory *memory, mpz_t *addr);
inline mpz_t *ram_get_register_by_indirect_pointer (RAM_Memory *memory,
						mpz_t *addr);

void ram_set_block_size (unsigned int);	// Default block size for newly created
					// memory structures.

unsigned int ram_memory_tree_height (RAM_Memory *);

#endif /* __ram_memory_h */
