/*
 * 	Random Access Machine emulator.
 * 	Text handling stuff.
 *
 * 	Copyright (C) 2002  Dmitry Rutsky
 */
#include "ram.h"	

RAM_Text *ram_text_new ()
{
   RAM_Text *rt = (RAM_Text *) calloc (1, sizeof (RAM_Text));

   if (! rt)
      err_fatal_perror ("calloc", "RAM_Text memory allocation failure");

   return rt;
}

void ram_text_reset (RAM_Text *rt)
{
   if (rt -> text)
   {
      int i;

      for (i = 0; i < (rt -> text_size); i ++)
	 if ((rt -> text) [i])
            free ((rt -> text) [i]);

      free (rt -> text);
      (rt -> text) = NULL;
   }

   if (rt -> instruction_line)
   {
      free (rt -> instruction_line);
      (rt -> instruction_line) = NULL;
   }

   (rt -> text_size) = 0;
}

void ram_text_delete (RAM_Text *rt)
{
   ram_text_reset (rt);
   free (rt);
}

