/*
 * 	Random Access Machine emulator.
 * 	Program text handling stuff, mainly used in the debugger.
 * 	
 * 	Copyright (C) 2002, 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 	This little piece is needed for convinience only.
 */
#ifndef __ram_text_h
#define __ram_text_h

typedef struct
{
   char **text;
   int text_size;
   unsigned int *instruction_line;	// Points corresponding source
   					// entries in `text'.
}
RAM_Text;

RAM_Text *ram_text_new ();
void ram_text_reset (RAM_Text *);
void ram_text_delete (RAM_Text *);

#endif /* __ram_text_h */
