-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gtk.Object;
with Gtk.Combo;
with Gtk.GEntry;
with Gtk.List;
with mcc.Gui.Widget.Peer;
with peer.Gtk_List;       use peer.Gtk_List;

package body mcc.Gui.Widget.Dropdown is
   -- the key to this implementation is that a Gtk_Combo actually
   -- contains a Gtk_List inside of it.  By simply storing this
   -- (since all of the methods are the same, we save a LOT of work!)
   type Mcc_Dropdown_Record is new Gtk.Combo.Gtk_Combo_Record with record
      Listbox : Gtk.List.Gtk_List;
   end record;
   type Mcc_Dropdown is access all Mcc_Dropdown_Record'Class;

   ---------------
   -- Add_Entry --
   ---------------

   procedure Add_Entry
     (Obj      : in out Dropdown;
      Location : in Natural;
      Text     : in String)
   is
   begin
      Add_Entry (Mcc_Dropdown (Obj.My_Peer).Listbox, Location, Text);
   end Add_Entry;

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj : in out Dropdown) is
   begin
      Clear (Mcc_Dropdown (Obj.My_Peer).Listbox);
   end Clear;

   -----------
   -- Count --
   -----------

   function Count (Obj : in Dropdown) return Natural is
   begin
      return Count (Mcc_Dropdown (Obj.My_Peer).Listbox);
   end Count;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj         : in out Dropdown;
      Parent      : in mcc.Gui.Container.Container'Class;
      X           : in Integer;
      Y           : in Integer;
      Width       : in Natural;
      Height      : in Natural;
      Number_Rows : in Natural)
   is
      New_Dropdown : Mcc_Dropdown;
   begin
      New_Dropdown := new Mcc_Dropdown_Record;
      Gtk.Combo.Initialize (Gtk.Combo.Gtk_Combo (New_Dropdown));
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Dropdown);

      mcc.Gui.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);
      New_Dropdown.Listbox :=
        Gtk.List.Gtk_List (Gtk.Combo.Get_List
                              (Gtk.Combo.Gtk_Combo (New_Dropdown)));
      Gtk.GEntry.Set_Editable
        (Gtk.Combo.Get_Entry (Gtk.Combo.Gtk_Combo (New_Dropdown)),
         False);
   end Create;

   ------------------
   -- Delete_Entry --
   ------------------

   procedure Delete_Entry
     (Obj   : in out Dropdown;
      Start : in Natural;
      Stop  : in Natural)
   is
   begin
      Delete_Entry (Mcc_Dropdown (Obj.My_Peer).Listbox, Start, Stop);
   end Delete_Entry;

   ------------------
   -- Get_Selected --
   ------------------

   function Get_Selected (Obj : in Dropdown) return Natural is
   begin
      return Get_Selected (Mcc_Dropdown (Obj.My_Peer).Listbox);
   end Get_Selected;

   -----------------
   -- Select_Item --
   -----------------

   procedure Select_Item (Obj : in out Dropdown; Number : in Natural) is
   begin
      Select_Item (Mcc_Dropdown (Obj.My_Peer).Listbox, Number);
   end Select_Item;

end Mcc.Gui.Widget.Dropdown;
