-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- Adapted from RAPID version 1.2 suggestion by W. Blair Watkinson II
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with System;
with Glib;
with mcc.Gui.Widget.Peer;
with mcc.Gtk_Signals;
with Gtk.Adjustment;
with Gtk.Object;
with Gtk.Scale;
with Gtk.Widget;
with Gdk.Event;           use type Gdk.Event.Gdk_Event_Mask;
with Gtk.Enums;

package body mcc.Gui.Widget.Scale is
   package Mcc_Object_Callback is new mcc.Gtk_Signals.Object_Callback_Void (
      Base_Type => Scale,
      Widget_Type => Scale_Pointer);

   procedure Mcc_Changed_Callback (Glib_Obj : System.Address) is
      Obj : Scale_Pointer := Mcc_Object_Callback.Find (Glib_Obj);
   begin
      if Obj.Change_Listener /= null then
         Obj.Change_Listener.all (Obj.all);
      end if;
   end Mcc_Changed_Callback;
   ------------
   -- Create --
   ------------

   procedure Create
     (Obj         : in out Scale;
      Parent      : in mcc.Gui.Container.Container'Class;
      X           : in Integer;
      Y           : in Integer;
      Width       : in Natural;
      Height      : in Natural;
      Min         : in Integer;
      Max         : in Integer;
      Mark_Every  : in Natural;
      Orientation : in Scale_Orientation := Horizontal;
      By          : in Natural           := 1)
   is

      New_Scale        : Gtk.Scale.Gtk_Scale;
      Scale_Adjustment : Gtk.Adjustment.Gtk_Adjustment;
   begin--Create
      Obj.Change_Listener := null;

      --From creating the widget it appears that page_size subtracts from the
      --Upper Value
      Gtk.Adjustment.Gtk_New
        (Adjustment     => Scale_Adjustment,
         Value          => 0.0,
         Lower          => Glib.Gdouble (Min),
         Upper          => Glib.Gdouble (Max),
         Step_Increment => Glib.Gdouble (By),
         Page_Increment => Glib.Gdouble (Mark_Every),
         Page_Size      => 0.0);

      case Orientation is
         when Horizontal =>
            Gtk.Scale.Gtk_New_Hscale
              (Scale      => New_Scale,
               Adjustment => Scale_Adjustment);
            Gtk.Scale.Set_Value_Pos
              (Scale => New_Scale,
               Pos   => Gtk.Enums.Pos_Right);
         when Vertical =>
            Gtk.Scale.Gtk_New_Vscale
              (Scale      => New_Scale,
               Adjustment => Scale_Adjustment);
            Gtk.Scale.Set_Value_Pos
              (Scale => New_Scale,
               Pos   => Gtk.Enums.Pos_Bottom);
      end case;
      Gtk.Scale.Set_Digits (New_Scale, 0);
      Gtk.Scale.Set_Update_Policy (New_Scale, Gtk.Enums.Update_Delayed);
      --Have Object point to Scale Widget
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Scale);

      mcc.Gui.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);
   end Create;

   ---------
   -- Get --
   ---------

   function Get (Obj : in Scale) return Integer is
   begin
      return Integer (Gtk.Adjustment.Get_Value
                         (Adjustment =>
                             Gtk.Scale.Get_Adjustment
                               (The_Range =>
                                  Gtk.Scale.Gtk_Scale (Obj.My_Peer))));
   end Get;

   function Get_Scale_Listener (Obj : in Scale'Class) return Scale_Listener is
   begin
      return Obj.Change_Listener;
   end Get_Scale_Listener;
   ---------
   -- Set --
   ---------

   procedure Set (Obj : in out Scale; Location : in Integer) is
   begin
      Gtk.Adjustment.Set_Value
        (Adjustment =>
            Gtk.Scale.Get_Adjustment
              (The_Range => Gtk.Scale.Gtk_Scale (Obj.My_Peer)),
         Value      => Glib.Gdouble (Location));
   end Set;

   ------------------------
   -- Set_Scale_Listener --
   ------------------------

   --have to set this, not sure what I am listening to
   procedure Set_Scale_Listener
     (Obj      : in Scale_Pointer;
      Listener : in Scale_Listener)
   is
      Cb_Id : Glib.Guint;
   begin
      if Obj.Change_Listener = null then
         Cb_Id :=
            Mcc_Object_Callback.Connect
              (Obj         => Gtk.Object.Gtk_Object (Obj.My_Peer),
               Name        => "value_changed",
               Func        => Mcc_Changed_Callback'Access,
               Slot_Object => Obj);
      end if;
      Obj.Change_Listener := Listener;
   end Set_Scale_Listener;

end Mcc.Gui.Widget.Scale;
