---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  WIDGET_IO.ADS
--  Description : Read/Write Widgets to file
--
--  Copyright (C) 2000, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- This package exists so that it can be called from Gui.Window
-- It traverses the list of widgets calling the appropriate
-- method for each.
---------------------------------------------------------------
with gui.Widget;
with gui.Window;

package Widget_IO is
   Bad_File : exception;

   -- for each widget in file:
   -- read widget type
   -- create widget
   -- call Read_Widget method
   -- add to list
   procedure Read_Widgets
     (Window_Name : in String;
      Widget_List : out gui.Widget.Widget_List);

   -- for each widget in file:
   -- call Write_Widget method
   procedure Write_Widgets
     (Widgets : gui.Widget.Widget_List);

   -- for each widget in file:
   -- call Display_Widget method
   procedure Display_Widgets
     (Window  : in out gui.Window.GUI_Window;
      Widgets : in gui.Widget.Widget_List);

   -- walk through widget list creating Radio groups
   procedure Generate_Radio_Groups
     (Widgets : gui.Widget.Widget_List);

   -- walk through widget list creating procedures
   -- to read/select for each radio group
   procedure Generate_Radio_Groups_Body
     (Widgets : gui.Widget.Widget_List);
end Widget_IO;
