---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-DROPDOWN.ADS
--  Description : GUI Widget Dropdown
--
--  Copyright (C) 2000, Jonathan Busch and Martin Carlisle
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.Gui.Container;

package gui.Widget.Dropdown is

   type Dropdown is new GUI_Widget with record
      FG_Color : String_Pointer;
      BG_Color : String_Pointer;
      -- although this really should be a natural, we use
      -- a negative number as an error condition
      Number_Rows : Integer := 5;
      -- fill-in with this enumeration type
      Enumeration_Var  : String_Pointer;
      Enumeration_Type : String_Pointer;
      -- mcc gui components for entry
      FG_Entry               : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      BG_Entry               : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Rows_Entry             : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Enumeration_Var_Entry  : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Enumeration_Type_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into Dropdown,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Dropdown);

   -- Writes information to file from Dropdown
   procedure Write_Widget (Widget : in Dropdown);

   -- mcc 05/23/00
   procedure Generate_Action_Context_Clause
     (Widget : in Dropdown);

   -- SAG 02.Dec.1999
   procedure Generate_Callback_Context_Clause
     (Widget     : in Dropdown;
      Windowname : in String);

   function Has_Anything_To_Fill_Or_Read
     (Widget : in Dropdown)
      return   Boolean;

   procedure Generate_Fill_Action
     (Widget : in Dropdown);

   procedure Generate_Read_Action
     (Widget : in Dropdown);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Dropdown);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Dropdown);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Dropdown;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Generate_Widget_Creation
     (Widget      : in Dropdown;
      Window_Name : in String);

   procedure Set_Properties (Widget : in out Dropdown);

   procedure Apply_Properties (Widget : in out Dropdown);

   procedure Check_Properties (Widget : in out Dropdown; Ok : out Boolean);

end Gui.Widget.Dropdown;
