---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-RADIO_BUTTON.ADS
--  Description : GUI Widget Radio Button
--
--  Copyright (C) 1999, Martin Carlisle and Patrick Maes
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.Gui.Widget.Text_Entry;
with mcc.Gui.Container;

package gui.Widget.Radio_Button is
   type Radio_Button is new gui.Widget.GUI_Widget with record
      Text        : String_Pointer;
      Group       : String_Pointer;
      Text_Entry  : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Group_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Radio_Button);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Radio_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Radio_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Radio_Button);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Radio_Button;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Radio_Button;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Radio_Button);

   procedure Apply_Properties (Widget : in out Radio_Button);

   procedure Check_Properties
     (Widget : in out Radio_Button;
      Ok     : out Boolean);

end Gui.Widget.Radio_Button;
