-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk.Event;        use type Gdk.Event.Gdk_Event_Mask;
with Gtk.Object;
with Glib;             use Glib;
with Gtk.Box;
with Gtk.Container;
with Gtk.Fixed;
with Gtk.Drawing_Area;
with Gtk.Widget;
with Gdk;
with peer.Frame;       use peer.Frame;

package body mcc.tki.Container.Frame is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj          : in out Frame;
      Parent       : in Container'Class;
      X            : in Integer;
      Y            : in Integer;
      Width        : in Natural;
      Height       : in Natural;
      Border_Width : in Natural := 1)
   is
      Frame_Container : Mcc_Frame;
      Vbox            : Gtk.Box.Gtk_Vbox;
   begin
      Obj.Key_Handler   := null;
      Obj.Mouse_Handler := null;

      --Create new fixed
      Frame_Container := new Mcc_Frame_Record;
      Gtk.Fixed.Initialize (Frame_Container);

      Gtk.Drawing_Area.Gtk_New (Frame_Container.Drawing_Area);
      Gtk.Box.Gtk_New_Vbox (Box => Vbox, Homogeneous => False, Spacing => 0);
      Gtk.Fixed.Add
        (Container => Gtk.Fixed.Gtk_Fixed (Frame_Container),
         Widget    => Vbox);
      Gtk.Box.Show (Vbox);

      Gtk.Box.Pack_End
        (In_Box  => Vbox,
         Child   => Frame_Container.Drawing_Area,
         Expand  => True,
         Fill    => True,
         Padding => 0);
      Gtk.Fixed.Show (Gtk.Fixed.Gtk_Fixed (Frame_Container));

      --Set border width
      --@todo adapt to new gtk
      -- if Border_Width /= 0 then
      --    Gtk.Drawing_Area.Set_Border_Width
      --      (Container    => Frame_Container.Drawing_Area,
      --       Border_Width => Guint(Border_Width));
      -- end if;

      --Have Object point to fixed Container Frame
      Obj.My_Peer := Gtk.Object.Gtk_Object (Frame_Container);

      --Set smallest size possible, can grow but won't shink any smaller
      Gtk.Widget.Set_USize
        (Widget => Gtk.Widget.Gtk_Widget (Frame_Container.Drawing_Area),
         Width  => Glib.Gint (Width),
         Height => Glib.Gint (Height));

      Gtk.Fixed.Put
        (Fixed  => Gtk.Fixed.Gtk_Fixed (Parent.My_Peer),
         Widget => Gtk.Widget.Gtk_Widget (Frame_Container),
         X      => Glib.Gint (X),
         Y      => Glib.Gint (Y));

      -- We must set the event mask first, because it must be done
      -- before the widget is "realized" (whatever that means).
      Gtk.Widget.Add_Events
        (Widget => Gtk.Widget.Gtk_Widget (Frame_Container.Drawing_Area),
         Events => Gdk.Event.Button_Motion_Mask +
                   Gdk.Event.Button_Press_Mask +
                   Gdk.Event.Button_Release_Mask +
                   Gdk.Event.Key_Release_Mask +
                   Gdk.Event.Key_Press_Mask +
                   Gdk.Event.Pointer_Motion_Mask);

      Gtk.Widget.Show (Gtk.Widget.Gtk_Widget (Frame_Container.Drawing_Area));
   end Create;

end mcc.tki.Container.Frame;
