-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gtk.Check_Button;
with Gtk.Container;
with Gtk.Event_Box;
with Gtk.Object;
with Gtk.Widget;
with mcc.tki.Widget.Peer;
package body mcc.tki.Widget.Button.Check is

   function Get_Check
     (Button : Check_Button'Class)
      return   Gtk.Check_Button.Gtk_Check_Button
   is
   begin
      return Gtk.Check_Button.Gtk_Check_Button (
        Gtk.Widget.Widget_List.Get_Data
  (Gtk.Widget.Widget_List.First
      (Gtk.Container.Children (Gtk.Container.Gtk_Container (Button.My_Peer)))))
;
   end Get_Check;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Check_Button;
      Parent : in mcc.tki.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural;
      Text   : in String)
   is
      New_Button    : Gtk.Check_Button.Gtk_Check_Button;
      New_Event_Box : Gtk.Event_Box.Gtk_Event_Box;
   begin
      Obj.Push_Handler := null;

      Gtk.Event_Box.Gtk_New (New_Event_Box);
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Event_Box);

      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);

      Gtk.Check_Button.Gtk_New (Check_Button => New_Button, Label => Text);

      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (New_Event_Box),
         Widget    => New_Button);
      Gtk.Check_Button.Show (New_Button);

   end Create;

   ----------------
   -- Is_Checked --
   ----------------

   function Is_Checked (Obj : in Check_Button) return Boolean is
   begin
      return Gtk.Check_Button.Get_Active (Toggle_Button => Get_Check (Obj));
   end Is_Checked;

   ------------------
   -- Select_Check --
   ------------------

   procedure Select_Check (Obj : in out Check_Button) is
   begin
      Gtk.Check_Button.Set_Active
        (Toggle_Button => Get_Check (Obj),
         Is_Active     => True);
   end Select_Check;

   --------------------
   -- Unselect_Check --
   --------------------

   procedure Unselect_Check (Obj : in out Check_Button) is
   begin
      Gtk.Check_Button.Set_Active
        (Toggle_Button => Get_Check (Obj),
         Is_Active     => False);
   end Unselect_Check;

   ------------------------------------------------
   -- procedure Set_Check
   --
   -- Select if true, unselect if false
   ------------------------------------------------
   procedure Set_Check (Obj : in out Check_Button; To : in Boolean) is
   begin
      if To then
         Select_Check (Obj);
      else
         Unselect_Check (Obj);
      end if;
   end Set_Check;

end mcc.tki.Widget.Button.Check;
