-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           GTK PEER
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Ada.Unchecked_Conversion;
with Glib;
with Gdk.Types;
with Gdk.Event;
with Gdk.Window;
with Gtk.Fixed;
with Gtk.Widget;
with mcc.tki.Container.Window;
with mcc.tki.Widget.Dropdown;
with mcc.tki.Widget.Scale;

package body mcc.tki.Widget.Peer is

   -----------
   -- Setup --
   -----------

   procedure Setup
     (Obj    : in out mcc.tki.Widget.Widget'Class;
      Parent : in mcc.tki.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural)
   is
      type Parent_Access is access constant mcc.tki.Container.Container'Class;
      function Convert is new Ada.Unchecked_Conversion (
         Parent_Access,
         mcc.tki.Container.Container_Pointer);
      use type Gdk.Event.Gdk_Event_Mask;
   begin
      Obj.Key_Handler   := null;
      Obj.Mouse_Handler := null;

      -- We must set the event mask first, because it must be done
      -- before the widget is "realized" (whatever that means).
      --
      -- if statement shuts up the error because I guess the
      -- combo box realizes itself too early?
      if not (Obj in mcc.tki.Widget.Dropdown.Dropdown'Class) and
         not (Obj in mcc.tki.Widget.Scale.Scale'Class)
      then
         Gtk.Widget.Add_Events
           (Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
            Events => Gdk.Event.Button_Motion_Mask +
                      Gdk.Event.Key_Release_Mask +
                      Gdk.Event.Key_Press_Mask +
                      Gdk.Event.Button_Press_Mask +
                      Gdk.Event.Button_Release_Mask +
                      Gdk.Event.Pointer_Motion_Mask);
      end if;

      --Set smallest size possible, can grow but won't shink any smaller
      Gtk.Widget.Set_USize
        (Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Width  => Glib.Gint (Width),
         Height => Glib.Gint (Height));

      Gtk.Fixed.Put
        (Fixed  => Gtk.Fixed.Gtk_Fixed (mcc.tki.Container.Get_Peer (Parent)),
         Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         X      => Glib.Gint (X),
         Y      => Glib.Gint (Y));
      Gtk.Widget.Show (Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      Obj.Parent := Convert (Parent'Unchecked_Access);
   end Setup;

end mcc.tki.Widget.Peer;
