with mcc.gui.container.window;
with ada.text_io;
with gdk.event;
with mcc.gui.widget.label;
with mcc.gui.colors;

procedure window2 is
   Window  : aliased mcc.gui.container.window.main_window;
   label   : aliased mcc.gui.widget.label.label;

   procedure Key_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Key_Event) is
   begin
      ada.text_io.put_line("key " &
         mcc.gui.key_action_type'image(event.action) &
         mcc.gui.key_type'image(event.key));
   end Key_Listener;

   procedure Mouse_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Mouse_Event) is
   begin
      null;
--      ada.text_io.put_line("window2" &
--         mcc.gui.mouse_action_type'image(event.action) & " " &
--         mcc.gui.mouse_button'image(event.button) &
--         natural'image(event.x) & natural'image(event.y));
   end Mouse_Listener;


   procedure resize_procedure(
      obj : in out mcc.gui.container.window.window'class;
      width : in integer;
      height :in integer) is
   begin
      if width /= 300 or else height /= 300 then
         ada.text_io.put_line(integer'image(width) &
            integer'image(height));
         mcc.gui.resize(mcc.gui.sized_object(obj),300,300);
      end if;
   end resize_procedure;

begin
   -- test window functions
   mcc.gui.container.window.create(window,
      100,100,300,300);
   mcc.gui.container.window.set_title(window,"Fr""ed");

   mcc.gui.container.window.hide(window);
   delay 1.0;
   mcc.gui.container.window.show(window);
   mcc.gui.container.window.set_resize_handler(window'unchecked_access,
      resize_procedure'unrestricted_access);
   mcc.gui.container.window.to_top(window);
   Mcc.Gui.Widget.Label.Create
     (Obj     => Label,
      Parent  => Window,
      X       => 10,
      Y       => 10,
      Width   => 50,
      Height  => 20,
      Justify => Mcc.Gui.Widget.Label.Left,
      Text    => "First widget!");
   Mcc.Gui.Widget.Label.Set_Text(
      Obj  => Label,
      Text => "Text changed!");
   Mcc.Gui.Widget.Label.Set_Foreground_Color(
      Obj => Label,
      New_Color => Mcc.Gui.Colors.Named_Color(Mcc.Gui.Colors.Blue));
   Mcc.Gui.Widget.Label.Set_Background_Color(
      Obj => Label,
      New_Color => Mcc.Gui.Colors.Named_Color(Mcc.Gui.Colors.Green));
   Mcc.Gui.Widget.Label.Move(Label,50,50);
   Mcc.Gui.Widget.Label.Resize(Label,450,20);
   mcc.gui.set_mouse_listener(label'unchecked_access,
      mouse_listener'unrestricted_access);
   mcc.gui.set_key_listener(label'unchecked_access,
      key_listener'unrestricted_access);
   mcc.gui.widget.label.Set_Cursor
     (Obj => label,
      Cursor => mcc.gui.resize_sw);
   mcc.gui.widget.label.set_tooltip_text(
      Obj => label,
      Text => "A tooltip!");
   --gdk.event.set_show_events;
   mcc.gui.container.window.event_loop;
end window2;
