with Ada.Command_Line;
with Ada.Strings.Fixed;
with GNAT.IO;

package body mcc.Directory_Operations is

   procedure Determine_Rapid_Root_Dir is
      use type GNAT.OS_Lib.String_Access;
      Str_Ptr : GNAT.OS_Lib.String_Access;
      Last_Slash : Natural;
   begin
      Str_Ptr :=
         GNAT.OS_Lib.Locate_Exec_On_Path (Ada.Command_Line.Command_Name);
      if Str_Ptr = null then
         GNAT.IO.Put_Line
           (" Mcc.Directory_Operations.Determine_Rapid_Root_Dir: " &
            "GNAT.OS_Lib.Locate_Exec_On_Path returns null");
         return;
      end if;
      for I in Str_Ptr.all'Range loop
         if Str_Ptr (I) = '\' then
            Str_Ptr (I) := '/';
         end if;
      end loop;
      Last_Slash :=
         Ada.Strings.Fixed.Index (Str_Ptr.all, "/", Ada.Strings.Backward);
      if Last_Slash = 0 then
         GNAT.IO.Put_Line
           ("Mcc.Directory_Operations.Determine_Rapid_Root_Dir: " &
            "GNAT.OS_Lib.Locate_Exec_On_Path returns " & Str_Ptr.all);
         return;
      end if;
      Rapid_Root_Dir := new String' (Str_Ptr (1 .. Last_Slash));
      -- GNAT.IO.Put_Line
      --   ("Mcc.Directory_Operations.Determine_Rapid_Root_Dir: " &
      --    "Rapid_Root_Dir is " & Rapid_Root_Dir.all);
   end Determine_Rapid_Root_Dir;

end mcc.Directory_Operations;

