---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  FONT_ACTIONS.ADB
--  Description : Actions while selecting a font
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Subwindow_Actions;
with font_selection_dialog_window;
with mcc.tki.Fonts;
with mcc.tki.Widget.Listbox;
with mcc.tki.Widget.Label;
with Ada.Characters.Handling;
package body Font_Actions is
   Current_Widget : gui.Widget.Widget_Access;
   type Size_Array is array (Natural range <>) of mcc.tki.Fonts.Font_Size;
   Sizes : Size_Array :=
     (1  => 8,
      2  => 9,
      3  => 10,
      4  => 11,
      5  => 12,
      6  => 18,
      7  => 20,
      8  => 22,
      9  => 24,
      10 => 26,
      11 => 28,
      12 => 36,
      13 => 48,
      14 => 72);

   function Display_Enum (Item : in String) return String is
      Output : String  := Ada.Characters.Handling.To_Lower (Item);
      First  : Boolean := True;
   begin
      for i in Output'Range loop
         if First then
            Output (i) := Ada.Characters.Handling.To_Upper (Output (i));
            First      := False;
         elsif Output (i) = '_' then
            Output (i) := ' ';
            First      := True;
         end if;
      end loop;

      return Output;
   end Display_Enum;

   -------------------
   -- Cancel_Dialog --
   -------------------
   procedure Cancel_Dialog is
   begin
      mcc.tki.Container.Window.Destroy
        (font_selection_dialog_window.font_selection_dialog_window);
      Subwindow_Actions.Change_Font_Done;
   end Cancel_Dialog;

   -------------------
   -- Cancel_Dialog --
   -------------------
   procedure Cancel_Dialog
     (Obj : in out mcc.tki.Widget.Button.Button'Class)
   is
   begin
      Cancel_Dialog;
   end Cancel_Dialog;

   -------------------
   -- Cancel_Dialog --
   -------------------
   procedure Cancel_Dialog
     (Obj : in out mcc.tki.Container.Window.Window'Class)
   is
   begin
      Cancel_Dialog;
   end Cancel_Dialog;

   -----------------
   -- Change_Font --
   -----------------

   procedure Change_Font (The_Widget : in gui.Widget.Widget_Access) is
   begin
      Current_Widget := The_Widget;
      font_selection_dialog_window.Generate_Window;
      -- add information to Font_Family list
      for i in reverse mcc.tki.Fonts.Font_Family'Range loop
         mcc.tki.Widget.Listbox.Add_Entry
           (Obj      => font_selection_dialog_window.family_box,
            Location => 0,
            Text     => Display_Enum (mcc.tki.Fonts.Font_Family'Image (i)));
      end loop;

      mcc.tki.Widget.Listbox.Select_Item
        (Obj    => font_selection_dialog_window.family_box,
         Number => mcc.tki.Fonts.Font_Family'Pos (The_Widget.Font_Family) +
                   1);

      -- add information to Font_Style list
      for i in reverse mcc.tki.Fonts.Font_Style'Range loop
         mcc.tki.Widget.Listbox.Add_Entry
           (Obj      => font_selection_dialog_window.style_box,
            Location => 0,
            Text     => Display_Enum (mcc.tki.Fonts.Font_Style'Image (i)));
      end loop;

      mcc.tki.Widget.Listbox.Select_Item
        (Obj    => font_selection_dialog_window.style_box,
         Number => mcc.tki.Fonts.Font_Style'Pos (The_Widget.Font_Style) + 1);

      -- add information to Font_Size list
      for i in reverse Sizes'Range loop
         mcc.tki.Widget.Listbox.Add_Entry
           (Obj      => font_selection_dialog_window.size_box,
            Location => 0,
            Text     => mcc.tki.Fonts.Font_Size'Image (Sizes (i)));

      end loop;

      for i in Sizes'Range loop
         if The_Widget.Font_Size = Sizes (i) then
            mcc.tki.Widget.Listbox.Select_Item
              (Obj    => font_selection_dialog_window.size_box,
               Number => i);
         end if;
      end loop;

      mcc.tki.Container.Window.Set_Close_Handler
        (Obj     =>
           font_selection_dialog_window.font_selection_dialog_window'Access,
         Handler => Cancel_Dialog'Access);
   end Change_Font;

   ------------------
   -- Default_Font --
   ------------------

   procedure Default_Font (Obj : in out mcc.tki.Widget.Button.Button'Class) is
   begin
      Current_Widget.Have_Font := False;
      Subwindow_Actions.Change_Font_Done;
      mcc.tki.Container.Window.Destroy
        (font_selection_dialog_window.font_selection_dialog_window);
      mcc.tki.Widget.Label.Set_Text
        (Obj  => Current_Widget.Font_Label.all,
         Text => "Font:");
      mcc.tki.Widget.Label.Set_Text
        (Obj  => Current_Widget.Style_Label.all,
         Text => "Default");
   end Default_Font;

   ----------------
   -- Ok_Pressed --
   ----------------

   procedure Ok_Pressed (Obj : in out mcc.tki.Widget.Button.Button'Class) is
   begin
      Current_Widget.Have_Font   := True;
      Current_Widget.Font_Size   :=
        Sizes (mcc.tki.Widget.Listbox.Get_Selected
                  (font_selection_dialog_window.size_box));
      Current_Widget.Font_Style  :=
         mcc.tki.Fonts.Font_Style'Val
           (mcc.tki.Widget.Listbox.Get_Selected
               (font_selection_dialog_window.style_box) -
            1);
      Current_Widget.Font_Family :=
         mcc.tki.Fonts.Font_Family'Val
           (mcc.tki.Widget.Listbox.Get_Selected
               (font_selection_dialog_window.family_box) -
            1);
      Subwindow_Actions.Change_Font_Done;
      mcc.tki.Container.Window.Destroy
        (font_selection_dialog_window.font_selection_dialog_window);
      mcc.tki.Widget.Label.Set_Text
        (Obj  => Current_Widget.Font_Label.all,
         Text => "Font: " &
                 Display_Enum
                    (mcc.tki.Fonts.Font_Family'Image
                        (Current_Widget.Font_Family)));
      mcc.tki.Widget.Label.Set_Text
        (Obj  => Current_Widget.Style_Label.all,
         Text =>
           Display_Enum
              (mcc.tki.Fonts.Font_Style'Image (Current_Widget.Font_Style)) &
           mcc.tki.Fonts.Font_Size'Image (Current_Widget.Font_Size) &
           " pt");
   end Ok_Pressed;

end Font_Actions;
