---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-PICTURE.ADB
--  Description : GUI Widget Picture Picture
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Gui_Enum;
with File_Helpers;
with mcc.Common_Dialogs;
with picture_dialog_Window;
with mcc.tki.Widget.Picture;
with mcc.tki.Widget.Label;   use type mcc.tki.Widget.Widget_Pointer;
with Generate_Helpers;

package body gui.Widget.Picture is
   -- reads information from file into Picture,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Picture) is
   begin
      Read_Widget (GUI_Widget (Widget));
      Widget.Picture           := Get_String;
      File_Helpers.Token_Index := File_Helpers.Token_Index + 1;
   end Read_Widget;

   -- Writes information to file from Picture
   procedure Write_Widget (Widget : in Picture) is
   begin
      File_Helpers.Put (Gui_Enum.Img (Gui_Enum.Picture) & " ");
      Write_Widget (GUI_Widget (Widget));
      File_Helpers.P (" """ & Widget.Picture.all & """ ", Indent => False);
   end Write_Widget;

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause (Widget : in Picture) is
   begin
      Generate_Helpers.Generate_With ("mcc.tki.Widget.Picture");
      Generate_Helpers.Generate_With ("mcc.tki.Image");
   end Generate_Widget_Context_Clause;

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration (Widget : in Picture) is
   begin
      File_Helpers.P
        (Widget.Name.all & " : aliased mcc.tki.Widget.Picture.Picture;");
      File_Helpers.P
        (Generate_Helpers.Undot_Name (Widget.Picture.all) &
         "_Image : aliased mcc.tki.Image.External_Image;");
   end Generate_Widget_Declaration;

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Picture;
      Window_Name : in String)
   is
      procedure P (Text : String) is
      begin
         File_Helpers.P (Text);
      end P;
   begin
      P ("mcc.tki.Image.Create");
      P ("  (Obj  => " &
         Generate_Helpers.Undot_Name (Widget.Picture.all) &
         "_Image,");
      P ("   Name => " & """" & Widget.Picture.all & """);");
      P ("mcc.tki.Widget.Picture.Create");
      P ("  (Obj    => " & Widget.Name.all & ",");
      P ("   Parent => " & Window_Name & ",");
      P ("   X      =>" & Integer'Image (Widget.x) & ",");
      P ("   Y      =>" & Integer'Image (Widget.y) & ",");
      P ("   Width  =>" & Integer'Image (Widget.Width) & ",");
      P ("   Height =>" & Integer'Image (Widget.Height) & ",");
      P ("   Image  => " &
         Generate_Helpers.Undot_Name (Widget.Picture.all) &
         "_Image);");
   end Generate_Widget_Creation;

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Picture;
      Container : in out mcc.tki.Container.Container'Class)
   is
      Excepted : Boolean := False;
   begin
      begin
         mcc.tki.Image.Create (Widget.Image, Widget.Picture.all);
      exception
         when others =>
            Excepted := True;
      end;

      if not Excepted then
         if Widget.The_Widget = null
           or else not (Widget.The_Widget.all in 
              mcc.tki.Widget.Picture.Picture'Class)
         then
            Widget.The_Widget := new mcc.tki.Widget.Picture.Picture;
         end if;

         mcc.tki.Widget.Picture.Create
           (Obj    => mcc.tki.Widget.Picture.Picture (Widget.The_Widget.all),
            Parent => Container,
            X      => Widget.x,
            Y      => Widget.y,
            Width  => Widget.Width,
            Height => Widget.Height,
            Image  => Widget.Image);
      else
         if Widget.The_Widget = null
           or else not (Widget.The_Widget.all in mcc.tki.Widget.Label.Label'
              Class)
         then
            Widget.The_Widget := new mcc.tki.Widget.Label.Label;
         end if;

         mcc.tki.Widget.Label.Create
           (Obj     => mcc.tki.Widget.Label.Label (Widget.The_Widget.all),
            Parent  => Container,
            X       => Widget.x,
            Y       => Widget.y,
            Width   => Widget.Width,
            Height  => Widget.Height,
            Justify => mcc.tki.Widget.Label.Center,
            Text    => Widget.Picture.all);
      end if;

      Display_Widget (GUI_Widget (Widget), Container);
   exception
      when others =>
         mcc.Common_Dialogs.Ok_Box ("Can't display: " & Widget.Name.all);
   end Display_Widget;

   procedure Set_Properties (Widget : in out Picture) is
   begin
      picture_dialog_Window.Generate_Window;
      Widget.Properties    :=
        picture_dialog_Window.picture_dialog_Window'Access;
      Widget.Name_Entry    := picture_dialog_Window.entry1'Access;
      Widget.X_Entry       := picture_dialog_Window.entry2'Access;
      Widget.Y_Entry       := picture_dialog_Window.entry3'Access;
      Widget.Width_Entry   := picture_dialog_Window.entry4'Access;
      Widget.Height_Entry  := picture_dialog_Window.entry5'Access;
      Widget.Picture_Entry := picture_dialog_Window.entry6'Access;
      Set_Properties (GUI_Widget (Widget));
      if Widget.Picture /= null then
         mcc.tki.Widget.Text_Entry.Set_Text
           (Obj  => Widget.Picture_Entry.all,
            Text => Widget.Picture.all);
      end if;
   end Set_Properties;

   procedure Apply_Properties (Widget : in out Picture) is
   begin
      Apply_Properties (GUI_Widget (Widget));
      declare
         Picture : String :=
            mcc.tki.Widget.Text_Entry.Get_Text (Widget.Picture_Entry.all);
      begin
         Widget.Picture := new String'(Picture);
      end;
   end Apply_Properties;

   procedure Check_Properties (Widget : in out Picture; Ok : out Boolean) is
   begin
      Check_Properties (GUI_Widget (Widget), Ok);
      if Ok then
         Ok := (Widget.Picture /= null) and then (Widget.Picture.all /= "");
         if not Ok then
            mcc.tki.Widget.Text_Entry.Highlight (Widget.Picture_Entry.all);
         end if;
      end if;

      if not Ok then
         mcc.tki.Bell;
      end if;
   end Check_Properties;

end Gui.Widget.Picture;
